/*
 * Decompiled with CFR 0.152.
 */
package com.twelfthmile.yuga.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FsaContextMap {
    private final Map<String, String> map = new HashMap<String, String>();
    private final Map<String, String> valMap = new HashMap<String, String>();
    private String prevKey;
    private List<String> keys = new ArrayList<String>();

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }

    public int size() {
        return this.map.keySet().size();
    }

    public void put(String key, char value) {
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
        this.map.put(key, Character.toString(value));
        this.prevKey = key;
    }

    public void put(String key, int value) {
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
        this.map.put(key, String.valueOf(value));
        this.prevKey = key;
    }

    public void put(String key, String value) {
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
        this.map.put(key, value);
        this.prevKey = key;
    }

    public String getType() {
        return this.map.get("TYP");
    }

    public void setType(String type) {
        this.map.put("TYP", type);
    }

    public void setType(String type, String convertType) {
        this.map.put("TYP", type);
        if (convertType != null) {
            this.convert(convertType);
        }
    }

    public String getVal(String name) {
        return this.valMap.get(name);
    }

    public void setVal(String name, String val) {
        this.valMap.put(name, val);
    }

    public Map<String, String> getValMap() {
        return this.valMap;
    }

    public int getIndex() {
        return Integer.parseInt(this.map.get("INDEX"));
    }

    public void setIndex(int index) {
        this.map.put("INDEX", String.valueOf(index));
    }

    public void append(char value) {
        String preVal = this.map.get(this.prevKey);
        this.put(this.prevKey, preVal + value);
    }

    public void append(String value) {
        String preVal = this.map.get(this.prevKey);
        this.put(this.prevKey, preVal + value);
    }

    public char pop() {
        String preVal = this.map.get(this.prevKey);
        char ret = preVal.charAt(preVal.length() - 1);
        this.put(this.prevKey, preVal.substring(0, preVal.length() - 1));
        return ret;
    }

    public void convert(String kOld, String kNew) {
        if (this.map.containsKey(kOld)) {
            if (!this.map.containsKey(kNew)) {
                this.put(kNew, this.map.remove(kOld));
            } else {
                this.put(kNew, this.map.get(kNew) + this.map.remove(kOld));
            }
            this.prevKey = kNew;
        }
    }

    private void convert(String k) {
        StringBuilder sb = new StringBuilder();
        for (String key : this.keys) {
            sb.append(this.map.remove(key));
        }
        this.keys = new ArrayList<String>();
        this.put(k, sb.toString());
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void upgrade(char value) {
        switch (this.prevKey) {
            case "HH": {
                this.put("mm", value);
                this.prevKey = "mm";
                break;
            }
            case "mm": {
                this.put("ss", value);
                this.prevKey = "ss";
                break;
            }
            case "d": {
                this.put("MM", value);
                this.prevKey = "MM";
                break;
            }
            case "MM": 
            case "MMM": {
                this.put("yy", value);
                this.prevKey = "yy";
                break;
            }
            case "yy": {
                this.put("yyyy", this.map.remove("yy") + value);
                this.prevKey = "yyyy";
            }
        }
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public String print(String ... str) {
        if (str != null && str.length > 0) {
            return str[0] + " " + this.map.toString();
        }
        return this.map.toString();
    }

    public void putAll(FsaContextMap fsaContextMap) {
        this.map.putAll(fsaContextMap.map);
    }

    public Date getDate(Map<String, String> config) {
        StringBuilder sbf = new StringBuilder();
        StringBuilder sbs = new StringBuilder();
        boolean ifYear = false;
        boolean ifMonth = false;
        boolean ifDay = false;
        ArrayList<String> invalidDateContributors = new ArrayList<String>();
        try {
            SimpleDateFormat format;
            int d;
            int m;
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String key = entry.getKey();
                if (!this.allow(key)) continue;
                sbf.append(key).append(" ");
                sbs.append(entry.getValue()).append(" ");
                switch (key) {
                    case "yy": 
                    case "yyyy": {
                        ifYear = true;
                        break;
                    }
                    case "d": {
                        ifDay = true;
                        break;
                    }
                    case "MM": 
                    case "MMM": {
                        ifMonth = true;
                    }
                }
            }
            if (!ifYear && config.containsKey("YUGA_CONF_DATE")) {
                sbf.append("yyyy ");
                sbs.append(config.get("YUGA_CONF_DATE").split("-")[0]).append(" ");
            } else {
                int maxDate = Calendar.getInstance().get(1);
                if (this.map.containsKey("yy")) {
                    int y = Integer.parseInt(this.map.get("yy"));
                    if (y <= 0 || y >= maxDate % 1000 + 3) {
                        invalidDateContributors.add("yy");
                    }
                } else {
                    int y = Integer.parseInt(this.map.get("yyyy"));
                    if (y <= 1971 || y >= maxDate + 3) {
                        invalidDateContributors.add("yyyy");
                    }
                }
            }
            if (!ifMonth && config.containsKey("YUGA_CONF_DATE")) {
                sbf.append("MM ");
                sbs.append(config.get("YUGA_CONF_DATE").split("-")[1]).append(" ");
            } else if (this.map.containsKey("MM") && ((m = Integer.valueOf(this.map.get("MM")).intValue()) < 0 || m > 12)) {
                invalidDateContributors.add("MM");
            }
            if (!ifDay && config.containsKey("YUGA_CONF_DATE")) {
                sbf.append("dd ");
                sbs.append(config.get("YUGA_CONF_DATE").split("-")[2].split(" ")[0]).append(" ");
            } else if (this.map.containsKey("d") && ((d = Integer.valueOf(this.map.get("d")).intValue()) < 0 || d > 31)) {
                invalidDateContributors.add("d");
            }
            if (invalidDateContributors.size() > 0) {
                if (invalidDateContributors.size() == 1 && ((String)invalidDateContributors.get(0)).equals("MM") && ifDay && ifYear) {
                    format = new SimpleDateFormat("d/MM/" + (this.map.containsKey("yy") ? "yy" : "yyyy"));
                    return format.parse(this.map.get("MM") + "/" + this.map.get("d") + "/" + (this.map.containsKey("yy") ? this.map.get("yy") : this.map.get("yyyy")));
                }
                return null;
            }
            format = new SimpleDateFormat(sbf.toString(), Locale.ENGLISH);
            return format.parse(sbs.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean allow(String key) {
        return key.equals("d") || key.equals("MM") || key.equals("MMM") || key.equals("yy") || key.equals("yyyy") || key.equals("HH") || key.equals("mm") || key.equals("ss");
    }
}

