/*
 * Decompiled with CFR 0.152.
 */
package com.twelfthmile.yuga.utils;

import com.twelfthmile.yuga.types.GenTrie;
import com.twelfthmile.yuga.types.Pair;
import com.twelfthmile.yuga.types.RootTrie;
import com.twelfthmile.yuga.types.Trie;
import com.twelfthmile.yuga.utils.Constants;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Util {
    public static boolean isHour(char c1, char c2) {
        return (c1 == '0' || c1 == '1') && Util.isNumber(c2) || c1 == '2' && (c2 == '0' || c2 == '1' || c2 == '2' || c2 == '3' || c2 == '4');
    }

    public static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isNumber(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Util.isNumber(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isDateOperator(char c) {
        return c == '/' || c == '-' || c == ' ';
    }

    public static boolean isDelimiter(char c) {
        return c == ' ' || c == '.' || c == ',' || c == ')';
    }

    public static boolean meridienTimeAhead(String str, int i) {
        boolean isWordEndAtMeridien;
        boolean amOrPmStartAhead;
        boolean bl = amOrPmStartAhead = i + 1 < str.length() && (str.charAt(i) == 'a' || str.charAt(i) == 'p') && str.charAt(i + 1) == 'm';
        if (!amOrPmStartAhead) {
            return false;
        }
        boolean bl2 = isWordEndAtMeridien = i + 2 >= str.length();
        if (isWordEndAtMeridien) {
            return true;
        }
        char c = str.charAt(i + 2);
        boolean checkIfJustWordStart = c == ' ' || c == '.' || c == ',' || c == ')' || c == '-' || c == '\n';
        return checkIfJustWordStart;
    }

    public static boolean isTimeOperator(char c) {
        return c == ':';
    }

    public static Pair<Integer, String> checkTypes(RootTrie root, String type, String word) {
        int i;
        GenTrie t = root.next.get(type);
        for (i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            if (t.leaf && !t.next.containsKey(Character.valueOf(ch)) && Util.isTypeEnd(ch)) {
                return new Pair<Integer, String>(i - 1, t.token);
            }
            if (!t.child || !t.next.containsKey(Character.valueOf(ch))) break;
            t = t.next.get(Character.valueOf(ch));
        }
        if (t.leaf && i == word.length()) {
            return new Pair<Integer, String>(i - 1, t.token);
        }
        if (type.equals("FSA_MONTHS") && i < 1) {
            return null;
        }
        if (type.equals("FSA_MONTHS") || type.equals("FSA_DAYS")) {
            return Util.checkNonEngMonth(i, word, type);
        }
        return null;
    }

    public static Pair<Integer, String> checkNonEngMonth(int i, String word, String type) {
        HashMap<Set<String>, String> map = type.equals("FSA_MONTHS") ? Constants.month : Constants.day;
        char ch = '\u0000';
        if (i != word.length()) {
            while (i < word.length() && !Util.isTypeEnd(ch)) {
                ch = word.charAt(i);
                ++i;
            }
        }
        String toCheck = i == word.length() && !Util.isTypeEnd(ch) ? word.substring(0, i) : word.substring(0, i - 1);
        for (Map.Entry<Set<String>, String> pair : map.entrySet()) {
            if (!pair.getKey().contains(toCheck)) continue;
            return new Pair<Integer, String>(i - 1, pair.getValue());
        }
        return null;
    }

    public static boolean isTypeEnd(char ch) {
        return Util.isNumber(ch) || ch == '.' || ch == ' ' || ch == '-' || ch == ',' || ch == '/' || ch == ')' || ch == '!' || ch == '+' || ch == '*' || ch == '\r' || ch == '\n' || ch == '\'';
    }

    public static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isUpperAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLowerAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isUpperAlpha(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Util.isUpperAlpha(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerAlpha(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Util.isLowerAlpha(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Util.isAlpha(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Trie loadTokens() {
        Trie tokenTrie = new Trie();
        tokenTrie.loadTrie();
        return tokenTrie;
    }

    public static Integer parseStrToInt(String text) {
        if (text == null || text.isEmpty() || text.length() > 9) {
            return null;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean checkForTimeRange(String val) {
        if (!Util.isNumber(val) || val.length() < 7) {
            return false;
        }
        Integer fromTimeHour = Util.parseStrToInt(val.substring(0, 2));
        Integer toTimeHour = Util.parseStrToInt(val.substring(4, 6));
        if (fromTimeHour == null || toTimeHour == null) {
            return false;
        }
        return fromTimeHour < 24 && toTimeHour < 24;
    }

    public static boolean checkForNumRange(String val) {
        boolean valChecks;
        if (val == null || val.length() < 3 || !val.contains("-") || val.startsWith("00")) {
            return false;
        }
        String[] parts = val.split("-");
        if (parts.length != 2) {
            return false;
        }
        if (parts[0].length() == 0 || parts[0].length() > 6 || parts[1].length() == 0 || parts[1].length() > 6) {
            return false;
        }
        boolean lengthRelatedChecks = parts[1].length() >= parts[0].length() && parts[1].length() - parts[0].length() < 2;
        boolean bl = valChecks = Util.isNumber(parts[0]) && Util.isNumber(parts[1]) && Util.parseStrToInt(parts[1]) - Util.parseStrToInt(parts[0]) > 0;
        return lengthRelatedChecks && valChecks;
    }

    public static Date addHoursToJavaUtilDate(Date date, int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, hours);
        return calendar.getTime();
    }

    public static String addDaysToDate(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.add(5, days);
        return Constants.dateTimeFormatter().format(calendar.getTime());
    }

    public static Date getDateObject(String dateStr) {
        try {
            Date dt = Constants.dateTimeFormatter().parse(dateStr);
            return dt;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String addTimeStampSuffix(String hour) {
        return hour + ":00";
    }
}

