/*
 * Decompiled with CFR 0.152.
 */
package com.twelfthmile.yuga;

import com.twelfthmile.yuga.utils.Constants;
import com.twelfthmile.yuga.utils.Util;
import java.util.Arrays;

public class YugaMethods {
    static boolean lookAheadForMerid(String str, int index) {
        if (index + 4 >= str.length()) {
            return false;
        }
        for (int i = index + 1; i < index + 4; ++i) {
            if (!Util.meridienTimeAhead(str, i)) continue;
            return true;
        }
        return false;
    }

    static int lookAheadForNum(String str, int index) {
        for (int i = index + 1; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == ' ') continue;
            if (Util.isNumber(c)) {
                return i - 1;
            }
            return -1;
        }
        return -1;
    }

    static int lookAheadForInstr(String str, int index) {
        for (int i = index; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '.') continue;
            if (c == '*' || c == 'X' || c == 'x' || Util.isNumber(c)) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    static boolean isInstrNumStart(char c) {
        return c == '*' || c == 'X' || c == 'x';
    }

    static String getAmt(String type) {
        switch (type) {
            case "lakh": 
            case "lac": {
                return "00000";
            }
            case "k": {
                return "000";
            }
        }
        return "";
    }

    static boolean isCurrencyAhead(String type) {
        type = YugaMethods.getPotentialCurrString(type);
        return Arrays.asList(Constants.currAct).contains(type.toLowerCase());
    }

    static String getPotentialCurrString(String type) {
        int next = YugaMethods.nextSpace(type);
        type = type.substring(0, next);
        return type;
    }

    static int nextSpace(String str) {
        int i;
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            return i;
        }
        return i;
    }
}

