/*
 * Decompiled with CFR 0.152.
 */
package com.twelfthmile.yuga.types;

import com.twelfthmile.yuga.utils.Constants;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class Response {
    private String type;
    private Map<String, String> valMap;
    private String str;
    private int index;
    private Date date;

    private Response() {
    }

    public Response(String type, Map<String, String> valMap, Object str, int index) {
        this.type = type;
        this.valMap = valMap;
        if (str instanceof String) {
            this.str = (String)str;
        } else {
            this.date = (Date)str;
            this.str = Constants.dateTimeFormatter().format(this.date);
        }
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStr() {
        return this.str;
    }

    public void setStr(String str) {
        this.str = str;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Map<String, String> getValMap() {
        return this.valMap;
    }

    public void setValMap(Map<String, String> valMap) {
        this.valMap = valMap;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String toString() {
        return new StringJoiner(", ", Response.class.getSimpleName() + "[", "]").add("type='" + this.type + "'").add("valMap=" + this.valMap).add("str='" + this.str + "'").add("index=" + this.index).add("date=" + this.date).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response response = (Response)o;
        return this.getIndex() == response.getIndex() && this.getType().equals(response.getType()) && this.getValMap().equals(response.getValMap()) && this.getStr().equals(response.getStr());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getValMap(), this.getStr(), this.getIndex());
    }

    @Deprecated
    public String print() {
        return "{\"type\":\"" + this.type + "\", \"str\":\"" + this.str + "\", \"index\":\"" + this.index + "\", \"valMap\":" + this.printValMap() + "}";
    }

    private String printValMap() {
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<String, String> entry : this.valMap.entrySet()) {
            sb.append("\"" + entry.getKey() + "\":\"" + entry.getValue() + "\",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.append("}").toString();
    }
}

