package `in`.navanatech.zabaan.publishersdk

import `in`.navanatech.zabaan.publishersdk.data.PublisherRepository
import `in`.navanatech.zabaan.publishersdk.parsing.ViewTreeParser
import `in`.navanatech.zabaan.publishersdk.ui.BlockingOverlay
import `in`.navanatech.zabaan.publishersdk.util.ScreenshotHelper
import `in`.navanatech.zabaan.publishersdk.util.e
import `in`.navanatech.zabaan.publishersdk.util.rootView
import android.app.Activity
import android.widget.Toast
import androidx.activity.ComponentActivity
import androidx.lifecycle.lifecycleScope
import kotlinx.coroutines.launch
import java.io.File

class CaptureManager(private val repository: PublisherRepository) {

    fun captureScreen(activity: Activity) {
        val (screenshotName, screenshotPath) = ScreenshotHelper.takeScreenshot(activity)
        val viewNode = ViewTreeParser.parseViewTree(activity.rootView)
        e { viewNode.toString() }
        if (activity !is ComponentActivity) {
            Toast.makeText(
                activity,
                "Current Activity is not Supported, Please use AppComponentActivity",
                Toast.LENGTH_LONG
            ).show()
            return
        }

        activity.lifecycleScope.launch {
            BlockingOverlay.show(activity)
            repository.publishScreenshot(viewNode, screenshotName, File(screenshotPath))
            BlockingOverlay.hide(activity)
        }
    }
}