package `in`.navanatech.zabaan.publishersdk.data.network

import `in`.navanatech.zabaan.publishersdk.model.Acknowledgement
import `in`.navanatech.zabaan.publishersdk.model.Authentication
import com.skydoves.sandwich.ApiResponse
import okhttp3.MultipartBody
import retrofit2.http.*

/**
 * Publisher service
 *
 * @constructor Create empty Publisher service
 */
interface PublisherService {

    @GET("/api/v1/publisher/token")
    suspend fun getToken(@Query("code") code: String): ApiResponse<Authentication>

    @Multipart
    @POST("/api/v1/publisher/")
    suspend fun screenDetails(
        @Header("Authorization") token: String,
        @Part viewNode: MultipartBody.Part,
        @Part screenshot: MultipartBody.Part,
        @Part screenName: MultipartBody.Part,
        @Part version: MultipartBody.Part,
    ): ApiResponse<Acknowledgement>
}