package `in`.navanatech.zabaan.publishersdk.lifecycle

import `in`.navanatech.zabaan.publishersdk.util.NotificationHelper
import `in`.navanatech.zabaan.publishersdk.util.e
import android.content.Context
import androidx.lifecycle.*
import kotlinx.coroutines.channels.BufferOverflow
import kotlinx.coroutines.flow.*

/**
 * A class to observe the application process lifecycle.
 *
 * It is currently being used to show and hide the publisher sdk notification.
 *
 */
class ApplicationLifecycleObserver : LifecycleEventObserver {
    private val _applicationEventMutableFlow = MutableStateFlow<Lifecycle.Event?>(null)
    val applicationEventFlow = _applicationEventMutableFlow.asStateFlow()

    override fun onStateChanged(source: LifecycleOwner, event: Lifecycle.Event) {
        _applicationEventMutableFlow.value = event
    }
}