package `in`.navanatech.zabaan.publishersdk.lifecycle

import `in`.navanatech.zabaan.publishersdk.util.ActivityLifecycleCallbacks
import `in`.navanatech.zabaan.publishersdk.util.className
import `in`.navanatech.zabaan.publishersdk.util.i
import android.app.Activity
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow

/**
 * Screen tracker
 * A class to track changes in activity and fragment also allows you to get latest activity and fragment name.
 *
 * @constructor Create empty Screen tracker
 */
class ScreenTracker : ActivityLifecycleCallbacks {

    private val _activityMutableFlow = MutableStateFlow<Activity?>(null)
    val activityFlow = _activityMutableFlow.asStateFlow()

    override fun onActivityResumed(activity: Activity) {
        super.onActivityResumed(activity)
        i { "onActivityResumed: ${activity.className}" }
        _activityMutableFlow.value = activity
    }

    override fun onActivityPaused(activity: Activity) {
        super.onActivityPaused(activity)
        i { "onActivityPaused: ${activity.className}" }
        _activityMutableFlow.value = null
    }

    fun clearActivityFlow() {
        _activityMutableFlow.value = null
    }
}