package `in`.navanatech.zabaan.publishersdk.model

import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass

@JsonClass(generateAdapter = true)
data class ViewNode(
    @Json(name = "int_id")
    val intId: Int,
    @Json(name = "string_id")
    val stringId: String,
    @Json(name = "x")
    val x: Float,
    @Json(name = "y")
    val y: Float,
    @Json(name = "width")
    val width: Int,
    @Json(name = "height")
    val height: Int,
    @Json(name = "children")
    val children: List<ViewNode>,
    @Json(name = "is_interactive")
    val isInteractive: Boolean,
    @Json(name = "is_scrollable")
    val isScrollable: Boolean,
    @Json(name = "view_name")
    val viewName: String,
    @Json(name = "adapter_position")
    val adapterPosition: Int,
)