package `in`.navanatech.zabaan.publishersdk.util

import android.app.Activity
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity

/**
 * An extension property to get Root view from activity (fallback using window)
 */
val Activity.rootView: View
    get() = findViewById<View?>(android.R.id.content).rootView
        ?: window.decorView.findViewById(android.R.id.content)
        ?: error("Cannot find rootView")

val Activity.fragments: List<Fragment>
    get() {
        return when (this) {
            is AppCompatActivity -> {
                supportFragmentManager.fragments
            }
            is FragmentActivity -> {
                supportFragmentManager.fragments
            }
            else -> {
                error("Cannot find fragments, Activity is not an instance of AppCompatActivity")
            }
        }
    }
