package `in`.navanatech.zabaan.publishersdk.util

import android.content.res.Resources
import android.view.View
import androidx.fragment.app.Fragment

/**
 * An extension property to get String id of view
 * returns "no-id" if the view has not been assigned an ID
 */
val View.stringId: String
    get() {
        return if (id == View.NO_ID) "no-id" else try {
            resources.getResourceName(this.id)
        } catch (e: Resources.NotFoundException) {
            "no-id"
        }
    }

/**
 * An extension that provides child fragments of a fragment
 */
val Fragment.childFragments: List<Fragment>
    get() = childFragmentManager.fragments

/**
 * An extension property to get name of any class
 */
val Any.className: String
    get() = this::class.java.simpleName
