package `in`.navanatech.zabaan.publishersdk.util

import `in`.navanatech.zabaan.publishersdk.model.ScreenshotInfo
import android.app.Activity
import android.graphics.Bitmap
import android.graphics.Canvas
import androidx.fragment.app.Fragment
import java.io.File
import java.io.FileOutputStream

/**
 * Screenshot helper
 * A singleton object to take screenshot and save the file in internal storage with given name
 *
 * @constructor Create empty Screenshot helper
 */
object ScreenshotHelper {

    fun takeScreenshot(activity: Activity): ScreenshotInfo {
        val rootView = activity.rootView
        val screenshotName = getScreenshotName(activity)
        val bitmap = Bitmap.createBitmap(
            rootView.width,
            rootView.height,
            Bitmap.Config.ARGB_8888
        )

        // TODO: Color picker (com.github.skydoves:colorpickerview) isn't visible in screenshot
        val canvas = Canvas(bitmap)
        rootView.draw(canvas)

        val image = File(activity.filesDir, "$screenshotName.jpeg")
        FileOutputStream(image).use { outputStream ->
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, outputStream)
            outputStream.flush()
            outputStream.close()
        }
        i { "Screenshot captured for $screenshotName at ${image.path}" }
        return ScreenshotInfo(screenshotName, image.path)
    }

    private fun getScreenshotName(activity: Activity): String {
        val screenshotName = buildString {
            val fragmentNames = getFragmentNameList(activity)

            append(activity.className)
            fragmentNames.map { "_$it" }.forEach(this::append)
        }

        return screenshotName
    }

    private fun getFragmentNameList(activity: Activity): List<String> {
        val nameList = mutableListOf<String>()
        val visibleFragments = activity.fragments.filter(Fragment::isVisible)

        visibleFragments.forEach { fragment ->
            if (fragment.className == "NavHostFragment") {
                val visibleChildFragments = fragment.childFragments.filter(Fragment::isVisible)
                nameList.addAll(visibleChildFragments.map(Fragment::className))
            } else {
                nameList.add(fragment.className)
            }
        }

        return nameList
    }
}
