/*
 * Decompiled with CFR 0.152.
 */
package in.norbor.yoda;

import in.norbor.yoda.StringPair;
import java.util.StringTokenizer;

public abstract class BahtText {
    private static final String[] TXT_NUM = new String[]{"\u0e28\u0e39\u0e19\u0e22\u0e4c", "\u0e2b\u0e19\u0e36\u0e48\u0e07", "\u0e2a\u0e2d\u0e07", "\u0e2a\u0e32\u0e21", "\u0e2a\u0e35\u0e48", "\u0e2b\u0e49\u0e32", "\u0e2b\u0e01", "\u0e40\u0e08\u0e47\u0e14", "\u0e41\u0e1b\u0e14", "\u0e40\u0e01\u0e49\u0e32"};
    private static final String[] TXT_WEIGHT = new String[]{"", "\u0e2a\u0e34\u0e1a", "\u0e23\u0e49\u0e2d\u0e22", "\u0e1e\u0e31\u0e19", "\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e41\u0e2a\u0e19"};
    private static final String TXT_ZEROBAHT = "\u0e28\u0e39\u0e19\u0e22\u0e4c\u0e1a\u0e32\u0e17";

    private BahtText() {
    }

    public static String toText(double d) {
        return BahtText.toText(Double.toString(d));
    }

    public static String toText(String string) throws NumberFormatException {
        String string2 = string;
        BahtText.throwIfNull(string2);
        string2 = BahtText.removeWhitespace(string2);
        string2 = BahtText.padZeroIfDotPresented(string2);
        BahtText.validateFormat(string2);
        StringPair stringPair = BahtText.tokenizeStringWithDot(string2);
        if (BahtText.isStringNumberCompleteZero(stringPair)) {
            return TXT_ZEROBAHT;
        }
        return BahtText.generateResultString(stringPair);
    }

    private static void throwIfNull(String string) {
        if (string == null) {
            throw new NumberFormatException("\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25\u0e40\u0e1b\u0e47\u0e19\u0e04\u0e48\u0e32 null (Null Value)");
        }
    }

    private static String removeWhitespace(String string) {
        return string.replaceAll("\\s+|,", "");
    }

    private static String padZeroIfDotPresented(String string) {
        String string2 = string;
        if (string2.length() != 0) {
            if (string2.charAt(0) == '.') {
                string2 = "0" + string2;
            }
            if (string2.charAt(string2.length() - 1) == '.') {
                string2 = string2 + "0";
            }
        }
        return string2;
    }

    private static void validateFormat(String string) {
        if (string.equals("")) {
            throw new NumberFormatException("\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25\u0e40\u0e1b\u0e47\u0e19\u0e04\u0e48\u0e32\u0e27\u0e48\u0e32\u0e07 (Blank Value)");
        }
        if (!string.chars().allMatch(n -> n >= 48 && n <= 57 || n == 46)) {
            throw new NumberFormatException("\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25\u0e21\u0e35\u0e15\u0e31\u0e27\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e30 (Alphabet Value)");
        }
        if (string.indexOf(46) != string.lastIndexOf(46)) {
            throw new NumberFormatException("\u0e17\u0e28\u0e19\u0e34\u0e22\u0e21\u0e21\u0e32\u0e01\u0e01\u0e27\u0e48\u0e32 1 \u0e15\u0e31\u0e27");
        }
    }

    private static boolean isStringNumberCompleteZero(StringPair stringPair) {
        boolean bl = BahtText.isZero(stringPair.before);
        boolean bl2 = stringPair.after == null || BahtText.isZero(stringPair.after);
        return bl && bl2;
    }

    private static StringPair tokenizeStringWithDot(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        return new StringPair(string2, string3);
    }

    private static String generateResultString(StringPair stringPair) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder(0);
        String string = stringPair.before;
        String string2 = stringPair.after;
        if (!BahtText.isZero(string)) {
            stringArray = BahtText.splitString(string);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(BahtText.generateWordNumber(stringArray[i]));
                if (i + 1 < stringArray.length) {
                    stringBuilder.append("\u0e25\u0e49\u0e32\u0e19");
                    continue;
                }
                stringBuilder.append("\u0e1a\u0e32\u0e17");
            }
        }
        if (string2 != null) {
            if (string2.length() > 2) {
                string2 = string2.substring(0, 2);
            }
            if (string2.length() == 1) {
                string2 = string2 + "0";
            }
            for (String string3 : stringArray = BahtText.splitString(string2)) {
                stringBuilder.append(BahtText.generateWordNumber(string3));
            }
            if (string2.equals("00")) {
                stringBuilder.append("\u0e16\u0e49\u0e27\u0e19");
            } else {
                stringBuilder.append("\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c");
            }
        } else {
            stringBuilder.append("\u0e16\u0e49\u0e27\u0e19");
        }
        return stringBuilder.toString();
    }

    private static boolean isZero(String string) {
        return string.chars().allMatch(n -> n == 48);
    }

    private static String[] splitString(String string) {
        int n = string.length();
        int n2 = n % 6;
        int n3 = n / 6 + (n2 > 0 ? 1 : 0);
        String[] stringArray = new String[n3];
        int n4 = 0;
        int n5 = 0;
        if (n2 > 0) {
            stringArray[n5++] = string.substring(n4, n2);
            n4 += n2;
        }
        for (int i = n5; i < n3; ++i) {
            stringArray[n5++] = string.substring(n4, n4 + 6);
            n4 += 6;
        }
        return stringArray;
    }

    private static String generateWordNumber(String string) {
        StringBuilder stringBuilder = new StringBuilder(0);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '0') continue;
            if (i == n - 1 && c == '1' && Integer.parseInt(string) % 100 > 10) {
                stringBuilder.append("\u0e40\u0e2d\u0e47\u0e14");
            } else if (i == n - 2 && c == '2') {
                stringBuilder.append("\u0e22\u0e35\u0e48");
            } else if (i == n - 2 && c == '1') {
                stringBuilder.append("");
            } else {
                stringBuilder.append(TXT_NUM[c - 48]);
            }
            stringBuilder.append(TXT_WEIGHT[n - i - 1]);
        }
        return stringBuilder.toString();
    }
}

