/*
 * Decompiled with CFR 0.152.
 */
package yoda.handlers;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import yoda.handlers.LocalCache;
import yoda.traits.cache.LCache;

@ScalaSignature(bytes="\u0006\u0005\u00194Aa\u0002\u0005\u0001\u001b!)!\u0006\u0001C\u0001W!Ia\u0006\u0001a\u0001\u0002\u0004%\ta\f\u0005\nq\u0001\u0001\r\u00111A\u0005\u0002eB\u0011B\u0011\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0019\t\u000b1\u0003A\u0011I'\t\u000bY\u0003A\u0011A,\u0003+1{7-\u00197DC\u000eDW-\u00138uKJ\u001cW\r\u001d;pe*\u0011\u0011BC\u0001\tQ\u0006tG\r\\3sg*\t1\"\u0001\u0003z_\u0012\f7\u0001A\n\u0005\u000191\u0002\u0005\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t9b$D\u0001\u0019\u0015\tI\"$A\u0005j]R,'oY3qi*\u00111\u0004H\u0001\fC>\u0004\u0018\r\u001c7jC:\u001cWMC\u0001\u001e\u0003\ry'oZ\u0005\u0003?a\u0011\u0011#T3uQ>$\u0017J\u001c;fe\u000e,\u0007\u000f^8s!\t\t\u0003&D\u0001#\u0015\t\u0019C%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002&M\u0005AA/\u001f9fg\u00064WMC\u0001(\u0003\r\u0019w.\\\u0005\u0003S\t\u00121\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\f\t\u0003[\u0001i\u0011\u0001C\u0001\u0007Y\u000e\f7\r[3\u0016\u0003A\u0002\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\u000b\r\f7\r[3\u000b\u0005UR\u0011A\u0002;sC&$8/\u0003\u00028e\t1AjQ1dQ\u0016\f!\u0002\\2bG\",w\fJ3r)\tQ\u0004\t\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0003V]&$\bbB!\u0004\u0003\u0003\u0005\r\u0001M\u0001\u0004q\u0012\n\u0014a\u00027dC\u000eDW\r\t\u0015\u0003\t\u0011\u0003\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\r%t'.Z2u\u0015\u0005I\u0015!\u00026bm\u0006D\u0018BA&G\u0005\u0019IeN[3di\u00061\u0011N\u001c<pW\u0016$\"AT)\u0011\u0005mz\u0015B\u0001)=\u0005\u0019\te.\u001f*fM\")!+\u0002a\u0001'\u0006Q\u0011N\u001c<pG\u0006$\u0018n\u001c8\u0011\u0005]!\u0016BA+\u0019\u0005AiU\r\u001e5pI&sgo\\2bi&|g.A\u0005g_Jl\u0017\r^&fsR\u0019\u0001lY3\u0011\u0005e\u0003gB\u0001._!\tYF(D\u0001]\u0015\tiF\"\u0001\u0004=e>|GOP\u0005\u0003?r\na\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011q\f\u0010\u0005\u0006I\u001a\u0001\r\u0001W\u0001\u0007aJ,g-\u001b=\t\u000bI3\u0001\u0019A*")
public class LocalCacheInterceptor
implements MethodInterceptor,
LazyLogging {
    @Inject
    private LCache lcache;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        LocalCacheInterceptor localCacheInterceptor = this;
        synchronized (localCacheInterceptor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public LCache lcache() {
        return this.lcache;
    }

    public void lcache_$eq(LCache x$1) {
        this.lcache = x$1;
    }

    public Object invoke(MethodInvocation invocation) {
        BoxedUnit boxedUnit;
        String string;
        LocalCache annotated = invocation.getMethod().getAnnotation(LocalCache.class);
        String prefix = annotated.prefix();
        try {
            string = this.formatKey(prefix, invocation);
        }
        catch (Throwable t) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(t.getMessage(), t);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return invocation.proceed();
        }
        String key = string;
        Option cache = this.lcache().get(key, ManifestFactory$.MODULE$.Object());
        if (cache.isDefined()) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Cache: {} -> {}", (Object[])new String[]{key, cache.get().toString()});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            return cache.get();
        }
        Object any = invocation.proceed();
        int timeout = annotated.timeout();
        this.lcache().asyncset(key, any, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(timeout)).minutes());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Put: {} -> {} to Cache: ", (Object[])new String[]{key, any.toString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return any;
    }

    public String formatKey(String prefix, MethodInvocation invocation) {
        return new StringBuilder(1).append(prefix).append("_").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(invocation.getArguments()), (Function1 & Serializable)x$1 -> x$1.toString(), ClassTag$.MODULE$.apply(String.class))).mkString("_")).toString();
    }

    public LocalCacheInterceptor() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

