/*
 * Decompiled with CFR 0.152.
 */
package yoda.handlers;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import yoda.handlers.LocalCache;
import yoda.proxy.cache.LCache;

@ScalaSignature(bytes="\u0006\u0005\u00194Aa\u0002\u0005\u0001\u001b!)!\u0006\u0001C\u0001W!Ia\u0006\u0001a\u0001\u0002\u0004%\ta\f\u0005\nq\u0001\u0001\r\u00111A\u0005\u0002eB\u0011B\u0011\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0019\t\u000b1\u0003A\u0011I'\t\u000bY\u0003A\u0011A,\u0003+1{7-\u00197DC\u000eDW-\u00138uKJ\u001cW\r\u001d;pe*\u0011\u0011BC\u0001\tQ\u0006tG\r\\3sg*\t1\"\u0001\u0003z_\u0012\f7\u0001A\n\u0005\u000191\u0002\u0005\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t9b$D\u0001\u0019\u0015\tI\"$A\u0005j]R,'oY3qi*\u00111\u0004H\u0001\fC>\u0004\u0018\r\u001c7jC:\u001cWMC\u0001\u001e\u0003\ry'oZ\u0005\u0003?a\u0011\u0011#T3uQ>$\u0017J\u001c;fe\u000e,\u0007\u000f^8s!\t\t\u0003&D\u0001#\u0015\t\u0019C%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002&M\u0005AA/\u001f9fg\u00064WMC\u0001(\u0003\r\u0019w.\\\u0005\u0003S\t\u00121\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\f\t\u0003[\u0001i\u0011\u0001C\u0001\u0007Y\u000e\f7\r[3\u0016\u0003A\u0002\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\u000b\r\f7\r[3\u000b\u0005UR\u0011!\u00029s_bL\u0018BA\u001c3\u0005\u0019a5)Y2iK\u0006QAnY1dQ\u0016|F%Z9\u0015\u0005i\u0002\u0005CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$\u0001B+oSRDq!Q\u0002\u0002\u0002\u0003\u0007\u0001'A\u0002yIE\nq\u0001\\2bG\",\u0007\u0005\u000b\u0002\u0005\tB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0007S:TWm\u0019;\u000b\u0003%\u000bQA[1wCbL!a\u0013$\u0003\r%s'.Z2u\u0003\u0019IgN^8lKR\u0011a*\u0015\t\u0003w=K!\u0001\u0015\u001f\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0011V\u00011\u0001T\u0003)IgN^8dCRLwN\u001c\t\u0003/QK!!\u0016\r\u0003!5+G\u000f[8e\u0013:4xnY1uS>t\u0017!\u00034pe6\fGoS3z)\rA6-\u001a\t\u00033\u0002t!A\u00170\u0011\u0005mcT\"\u0001/\u000b\u0005uc\u0011A\u0002\u001fs_>$h(\u0003\u0002`y\u00051\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\tyF\bC\u0003e\r\u0001\u0007\u0001,\u0001\u0004qe\u00164\u0017\u000e\u001f\u0005\u0006%\u001a\u0001\ra\u0015")
public class LocalCacheInterceptor
implements MethodInterceptor,
LazyLogging {
    @Inject
    private LCache lcache;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        LocalCacheInterceptor localCacheInterceptor = this;
        synchronized (localCacheInterceptor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public LCache lcache() {
        return this.lcache;
    }

    public void lcache_$eq(LCache x$1) {
        this.lcache = x$1;
    }

    public Object invoke(MethodInvocation invocation) {
        BoxedUnit boxedUnit;
        String string;
        LocalCache annotated = invocation.getMethod().getAnnotation(LocalCache.class);
        String prefix = annotated.prefix();
        try {
            string = this.formatKey(prefix, invocation);
        }
        catch (Throwable t) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(t.getMessage(), t);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return invocation.proceed();
        }
        String key = string;
        Option cache = this.lcache().get(key, ManifestFactory$.MODULE$.Object());
        if (cache.isDefined()) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Cache: {} -> {}", (Object[])new String[]{key, cache.get().toString()});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            return cache.get();
        }
        Object any = invocation.proceed();
        int timeout = annotated.timeout();
        this.lcache().asyncset(key, any, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(timeout)).minutes());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Put: {} -> {} to Cache: ", (Object[])new String[]{key, any.toString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return any;
    }

    public String formatKey(String prefix, MethodInvocation invocation) {
        return new StringBuilder(1).append(prefix).append("_").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(invocation.getArguments()), (Function1 & Serializable)x$2 -> x$2.toString(), ClassTag$.MODULE$.apply(String.class))).mkString("_")).toString();
    }

    public LocalCacheInterceptor() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

