/*
 * Decompiled with CFR 0.152.
 */
package in.norbor.yoda.orm;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import in.norbor.yoda.jtype.JBcrypt;
import in.norbor.yoda.orm.ColumnMeta;
import in.norbor.yoda.orm.ColumnParser$;
import in.norbor.yoda.orm.MetaSchema;
import in.norbor.yoda.orm.MetaSchema$;
import in.norbor.yoda.orm.PStatement;
import in.norbor.yoda.utilities.Accessor$;
import in.norbor.yoda.utilities.AnnotationHelper$;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PManager$
implements LazyLogging {
    public static PManager$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new PManager$();
    }

    private Logger logger$lzycompute() {
        PManager$ pManager$ = this;
        synchronized (pManager$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public <A> int apply(A obj, TypeTags.TypeTag<A> evidence$1, ClassTag<A> evidence$2, Connection conn) {
        int n;
        try {
            n = this.insert(obj, evidence$1, evidence$2, conn);
        }
        catch (Throwable throwable) {
            n = this.update(obj, evidence$1, evidence$2, conn);
        }
        return n;
    }

    public final <A> int insert(A obj, TypeTags.TypeTag<A> evidence$3, ClassTag<A> evidence$4, Connection conn) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        MetaSchema meta = this.findMeta(evidence$3);
        String table = (String)meta.table().getOrElse((Function0 & Serializable & scala.Serializable)() -> obj.getClass().getSimpleName().toLowerCase());
        List<ColumnMeta> keys = ColumnParser$.MODULE$.colNames(evidence$3);
        String stmt = this.insertStatement(table, keys);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("STMT {}", new Object[]{stmt});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        PStatement p = new PStatement(stmt, conn);
        Map kvs = (Map)Accessor$.MODULE$.toMap(obj).map((Function1 & Serializable & scala.Serializable)k -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ColumnParser$.MODULE$.namingStategy((String)k._1())), k._2()), Map$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("KV {}", new Object[]{kvs});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        keys.foreach((Function1 & Serializable & scala.Serializable)k -> MODULE$.set(p, kvs.apply((Object)k.schemaName())));
        return p.update();
    }

    public final <A> int update(A obj, TypeTags.TypeTag<A> evidence$5, ClassTag<A> evidence$6, Connection conn) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Map<String, Object> kv = Accessor$.MODULE$.toMap(obj);
        MetaSchema meta = this.findMeta(evidence$5);
        String pk = meta.pk();
        List<ColumnMeta> columns = ColumnParser$.MODULE$.colNames(evidence$5);
        String table = (String)meta.table().getOrElse((Function0 & Serializable & scala.Serializable)() -> obj.getClass().getSimpleName().toLowerCase());
        String stmt = this.updateStatement(table, pk, columns);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("STMT {}", new Object[]{stmt});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        PStatement p = new PStatement(stmt, conn);
        Map kvs = (Map)kv.map((Function1 & Serializable & scala.Serializable)k -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ColumnParser$.MODULE$.namingStategy((String)k._1())), k._2()), Map$.MODULE$.canBuildFrom());
        ((List)columns.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PManager$.$anonfun$update$3(pk, x$1)))).foreach((Function1 & Serializable & scala.Serializable)k -> MODULE$.set(p, kvs.apply((Object)k.schemaName())));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("KV {}", new Object[]{kvs});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.set(p, kvs.apply((Object)pk));
        return p.update();
    }

    public final <A> int delete(A obj, TypeTags.TypeTag<A> evidence$7, Connection conn) {
        Map<String, Object> kv = Accessor$.MODULE$.toMap(obj);
        MetaSchema meta = this.findMeta(evidence$7);
        String pk = meta.pk();
        String table = obj.getClass().getSimpleName().toLowerCase();
        return new PStatement(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(37).append("\n         | DELETE ").append(table).append(" WHERE ").append(pk).append(" = ").append(kv.apply((Object)pk)).append("\n       ").toString())).stripMargin(), conn).update();
    }

    public Object set(PStatement p, Object v) {
        Object object = v;
        PStatement pStatement = object instanceof Boolean ? p.setBoolean(BoxesRunTime.unboxToBoolean((Object)v)) : (object instanceof Integer ? p.setInt(BoxesRunTime.unboxToInt((Object)v)) : (object instanceof Long ? p.setLong(BoxesRunTime.unboxToLong((Object)v)) : (object instanceof Float ? p.setDouble(BoxesRunTime.unboxToDouble((Object)v)) : (object instanceof Double ? p.setDouble(BoxesRunTime.unboxToDouble((Object)v)) : (object instanceof String ? p.setString((String)v) : (object instanceof Timestamp ? p.setTimestamp((Timestamp)v) : (object instanceof DateTime ? p.setDateTime((DateTime)v) : (object instanceof JBcrypt ? p.setString(((JBcrypt)v).hash()) : (object instanceof Blob ? p.setBlob((Blob)v) : (object instanceof byte[] ? p.setBytes((byte[])v) : BoxedUnit.UNIT))))))))));
        return pStatement;
    }

    public <T> MetaSchema findMeta(TypeTags.TypeTag<T> evidence$8) {
        return (MetaSchema)AnnotationHelper$.MODULE$.classAnnotations(evidence$8).get((Object)"TableSchema").map((Function1 & Serializable & scala.Serializable)a -> new MetaSchema((String)a.get((Object)"pk").getOrElse((Function0 & Serializable & scala.Serializable)() -> null), (Option<String>)a.get((Object)"name"))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new MetaSchema(MetaSchema$.MODULE$.apply$default$1(), MetaSchema$.MODULE$.apply$default$2()));
    }

    public String insertStatement(String table, List<ColumnMeta> keys) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(25).append("INSERT INTO ").append(table).append(" (").append(((TraversableOnce)keys.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.schemaName(), List$.MODULE$.canBuildFrom())).mkString(", ")).append(") VALUES (").append(this.params(keys.size())).append(")").toString())).stripMargin();
    }

    public String updateStatement(String table, String pk, List<ColumnMeta> columns) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(27).append("UPDATE ").append(table).append(" SET ").append(this.updateValue(columns, pk)).append(" = ? WHERE ").append(pk).append(" = ?").toString())).stripMargin();
    }

    public String updateValue(List<ColumnMeta> columns, String pk) {
        return ((TraversableOnce)((TraversableLike)columns.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.schemaName(), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)PManager$.$anonfun$updateValue$2(pk, k)))).mkString(" = ?, ");
    }

    public String params(int count) {
        return ((TraversableOnce)List$.MODULE$.fill(count, (Function0 & Serializable & scala.Serializable)() -> "?")).mkString(", ");
    }

    public static final /* synthetic */ boolean $anonfun$update$3(String pk$1, ColumnMeta x$1) {
        String string = x$1.schemaName();
        String string2 = pk$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$updateValue$2(String pk$2, String k) {
        String string = k;
        String string2 = pk$2;
        return string == null ? string2 != null : !string.equals(string2);
    }

    private PManager$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

