package in.norbor.yoda.orm.dbtype

import java.sql.PreparedStatement

import in.norbor.yoda.jtype.JDouble
import in.norbor.yoda.orm.PStatement

trait BigDecimalType {

  protected def pstmt: PreparedStatement

  protected def count: PStatement

  protected def index: Int

  def setBigDecimal(param: BigDecimal): PStatement = setBigDecimal(index, param.bigDecimal)

  def setBigDecimal(param: java.math.BigDecimal): PStatement = setBigDecimal(index, param)

  private def setBigDecimal(ind: Int, param: java.math.BigDecimal): PStatement = {
    pstmt.setBigDecimal(ind, param)
    count
  }

}
