/*
 * Decompiled with CFR 0.152.
 */
package yoda.orm;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Singleton;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import yoda.commons.Closer;
import yoda.orm.Persistant;
import yoda.orm.Persistant$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005!4AAB\u0004\u0001\u0019!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0013A\u0003B\u0002\u0017\u0001A\u0003%\u0011\u0006C\u0003.\u0001\u0011\u0005a\u0006C\u0003W\u0001\u0011\u0005qK\u0001\u0005ECR\f'-Y:f\u0015\tA\u0011\"A\u0002pe6T\u0011AC\u0001\u0005s>$\u0017m\u0001\u0001\u0014\t\u0001i1#\b\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005QYR\"A\u000b\u000b\u0005Y9\u0012\u0001D:dC2\fGn\\4hS:<'B\u0001\r\u001a\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u000e\u0002\u0007\r|W.\u0003\u0002\u001d+\tYA*\u0019>z\u0019><w-\u001b8h!\tq\u0012%D\u0001 \u0015\t\u0001\u0013\"A\u0004d_6lwN\\:\n\u0005\tz\"AB\"m_N,'/\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002\u000f\u0005\t\u0001/F\u0001*!\t1#&\u0003\u0002,\u000f\tQ\u0001+\u001a:tSN$\u0018M\u001c;\u0002\u0005A\u0004\u0013AD<ji\"\u001cuN\u001c8fGRLwN\\\u000b\u0003_M\"\"\u0001M%\u0015\u0005Eb\u0004C\u0001\u001a4\u0019\u0001!Q\u0001\u000e\u0003C\u0002U\u0012\u0011AU\t\u0003me\u0002\"AD\u001c\n\u0005az!a\u0002(pi\"Lgn\u001a\t\u0003\u001diJ!aO\b\u0003\u0007\u0005s\u0017\u0010C\u0003>\t\u0001\u0007a(A\u0003cY>\u001c7\u000e\u0005\u0003\u000f\u007f\u0005\u000b\u0014B\u0001!\u0010\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006\u00191/\u001d7\u000b\u0003\u0019\u000bAA[1wC&\u0011\u0001j\u0011\u0002\u000b\u0007>tg.Z2uS>t\u0007\"\u0002&\u0005\u0001\u0004Y\u0015\u0001\u00028b[\u0016\u0004\"\u0001T*\u000f\u00055\u000b\u0006C\u0001(\u0010\u001b\u0005y%B\u0001)\f\u0003\u0019a$o\\8u}%\u0011!kD\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002S\u001f\u0005yq/\u001b;i)J\fgn]1di&|g.\u0006\u0002Y7R\u0011\u0011L\u0018\u000b\u00035r\u0003\"AM.\u0005\u000bQ*!\u0019A\u001b\t\u000bu*\u0001\u0019A/\u0011\t9y\u0014I\u0017\u0005\u0006\u0015\u0016\u0001\ra\u0013\u0015\u0003\u0001\u0001\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\r%t'.Z2u\u0015\u0005)\u0017!\u00026bm\u0006D\u0018BA4c\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class Database
implements LazyLogging,
Closer {
    private final Persistant p;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public <T, R> R closer(T resource, Function1<T, R> block) {
        return (R)Closer.closer$((Closer)this, resource, block);
    }

    private Logger logger$lzycompute() {
        Database database = this;
        synchronized (database) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private Persistant p() {
        return this.p;
    }

    public <R> R withConnection(String name, Function1<Connection, R> block) {
        return this.closer(this.p().get(), (Function1 & Serializable)c -> {
            BoxedUnit boxedUnit;
            Object object;
            long start = System.nanoTime();
            try {
                object = block.apply(c);
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit2;
                long executionTime = (System.nanoTime() - start) / 1000L;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Execute in {} ms.", (Object)BoxesRunTime.boxToLong((long)executionTime));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                c.close();
                throw throwable;
            }
            long executionTime = (System.nanoTime() - start) / 1000L;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Execute in {} ms.", (Object)BoxesRunTime.boxToLong((long)executionTime));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            c.close();
            return object;
        });
    }

    public <R> R withTransaction(String name, Function1<Connection, R> block) {
        return this.closer(this.p().get(), (Function1 & Serializable)c -> {
            BoxedUnit boxedUnit;
            Object object;
            long start = System.nanoTime();
            try {
                try {
                    c.setTransactionIsolation(8);
                    c.setAutoCommit(false);
                    object = block.apply(c);
                }
                catch (Throwable t) {
                    c.rollback();
                    throw t;
                }
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit2;
                c.close();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Execute in {} ms.", (Object)BoxesRunTime.boxToLong((long)((System.nanoTime() - start) / 1000L)));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            c.close();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Execute in {} ms.", (Object)BoxesRunTime.boxToLong((long)((System.nanoTime() - start) / 1000L)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public Database() {
        LazyLogging.$init$((LazyLogging)this);
        Closer.$init$((Closer)this);
        this.p = new Persistant(Persistant$.MODULE$.apply$default$1());
    }
}

