/*
 * Decompiled with CFR 0.152.
 */
package yoda.security.modules.handlers;

import com.google.common.base.Stopwatch;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005m2Aa\u0001\u0003\u0001\u001b!)!\u0006\u0001C\u0001W!)a\u0006\u0001C!_\t\u0019\u0002K]8gS2,'/\u00138uKJ\u001cW\r\u001d;pe*\u0011QAB\u0001\tQ\u0006tG\r\\3sg*\u0011q\u0001C\u0001\b[>$W\u000f\\3t\u0015\tI!\"\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005Y\u0011\u0001B=pI\u0006\u001c\u0001a\u0005\u0003\u0001\u001dY\u0001\u0003CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]qR\"\u0001\r\u000b\u0005eQ\u0012!C5oi\u0016\u00148-\u001a9u\u0015\tYB$A\u0006b_B\fG\u000e\\5b]\u000e,'\"A\u000f\u0002\u0007=\u0014x-\u0003\u0002 1\t\tR*\u001a;i_\u0012Le\u000e^3sG\u0016\u0004Ho\u001c:\u0011\u0005\u0005BS\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0013'\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0014\u0002\u0007\r|W.\u0003\u0002*E\tYA*\u0019>z\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tA\u0006\u0005\u0002.\u00015\tA!\u0001\u0004j]Z|7.\u001a\u000b\u0003aY\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0007\"B\u001c\u0003\u0001\u0004A\u0014AC5om>\u001c\u0017\r^5p]B\u0011q#O\u0005\u0003ua\u0011\u0001#T3uQ>$\u0017J\u001c<pG\u0006$\u0018n\u001c8")
public class ProfilerInterceptor
implements MethodInterceptor,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ProfilerInterceptor profilerInterceptor = this;
        synchronized (profilerInterceptor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Object invoke(MethodInvocation invocation) {
        BoxedUnit boxedUnit;
        Object object;
        Stopwatch watch = Stopwatch.createStarted();
        String className = invocation.getMethod().getDeclaringClass().getSimpleName();
        String methodName = invocation.getMethod().getName();
        try {
            object = invocation.proceed();
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit2;
            long elapsed = watch.stop().elapsed(TimeUnit.MILLISECONDS);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("{}.{}, execute in {} ms.", new Object[]{className, methodName, BoxesRunTime.boxToLong((long)elapsed)});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        long elapsed = watch.stop().elapsed(TimeUnit.MILLISECONDS);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}.{}, execute in {} ms.", new Object[]{className, methodName, BoxesRunTime.boxToLong((long)elapsed)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return object;
    }

    public ProfilerInterceptor() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

