/*
 * Decompiled with CFR 0.152.
 */
package yoda.security.modules.authorize;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.db.Database;
import play.api.http.HttpVerbs;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import yoda.security.annotations.LocalCache;
import yoda.security.definitions.AccountRole$;
import yoda.security.entities.AccessEntity;
import yoda.security.mvc.authorize.Account;
import yoda.security.mvc.authorize.Account$;
import yoda.security.mvc.authorize.Authorizer;
import yoda.security.mvc.authorize.HTTPPermission;
import yoda.security.mvc.authorize.PermissionValidation;
import yoda.security.repositories.AccessSQL;
import yoda.security.repositories.AccountSQL;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005md!\u0002\b\u0010\u0001E9\u0002\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011e\u0002!\u0011!Q\u0001\niB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\t\u0002!\t!\u0012\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0011\u0019\u0001\u0007\u0001)A\u0005-\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007BB:\u0001A\u0003%1\rC\u0003u\u0001\u0011\u0005S\u000fC\u0004\u0002\u0012\u0001!\t%a\u0005\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA0\u0001\u0011%\u0011\u0011\r\u0002\u0013\t\u0006$\u0018MY1tK\u0006+H\u000f[8sSj,'O\u0003\u0002\u0011#\u0005I\u0011-\u001e;i_JL'0\u001a\u0006\u0003%M\tq!\\8ek2,7O\u0003\u0002\u0015+\u0005A1/Z2ve&$\u0018PC\u0001\u0017\u0003\u0011Ix\u000eZ1\u0014\u000b\u0001Ab$J\u0018\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\ty2%D\u0001!\u0015\t\u0001\u0012E\u0003\u0002#'\u0005\u0019QN^2\n\u0005\u0011\u0002#AC!vi\"|'/\u001b>feB\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\u0005QR$\bO\u0003\u0002+W\u0005\u0019\u0011\r]5\u000b\u00031\nA\u0001\u001d7bs&\u0011af\n\u0002\n\u0011R$\bOV3sEN\u0004\"a\b\u0019\n\u0005E\u0002#\u0001\u0006)fe6L7o]5p]Z\u000bG.\u001b3bi&|g.\u0001\u0002eE\u000e\u0001\u0001CA\u001b8\u001b\u00051$B\u0001\u001a*\u0013\tAdG\u0001\u0005ECR\f'-Y:f\u0003)\t7mY8v]R\u001c\u0016\u000b\u0014\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{M\tAB]3q_NLGo\u001c:jKNL!a\u0010\u001f\u0003\u0015\u0005\u001b7m\\;oiN\u000bF*A\u0005bG\u000e,7o]*R\u0019B\u00111HQ\u0005\u0003\u0007r\u0012\u0011\"Q2dKN\u001c8+\u0015'\u0002\rqJg.\u001b;?)\u00111\u0005*\u0013&\u0011\u0005\u001d\u0003Q\"A\b\t\u000bI\"\u0001\u0019\u0001\u001b\t\u000be\"\u0001\u0019\u0001\u001e\t\u000b\u0001#\u0001\u0019A!)\u0005\u0011a\u0005CA'S\u001b\u0005q%BA(Q\u0003\u0019IgN[3di*\t\u0011+A\u0003kCZ\f\u00070\u0003\u0002T\u001d\n1\u0011J\u001c6fGR\fAaY8oMV\ta\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u000611m\u001c8gS\u001eT!a\u0017/\u0002\u0011QL\b/Z:bM\u0016T\u0011!X\u0001\u0004G>l\u0017BA0Y\u0005\u0019\u0019uN\u001c4jO\u0006)1m\u001c8gA\u0005Q\u0001/\u001e2mS\u000ed\u0017n\u001d;\u0016\u0003\r\u00042\u0001Z5l\u001b\u0005)'B\u00014h\u0003%IW.\\;uC\ndWM\u0003\u0002i5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005),'\u0001\u0002'jgR\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\t1\fgn\u001a\u0006\u0002a\u0006!!.\u0019<b\u0013\t\u0011XN\u0001\u0004TiJLgnZ\u0001\faV\u0014G.[2mSN$\b%\u0001\u0004m_>\\W\u000f\u001d\u000b\u0003mr\u00042!G<z\u0013\tA(D\u0001\u0004PaRLwN\u001c\t\u0003?iL!a\u001f\u0011\u0003\u000f\u0005\u001b7m\\;oi\")Q0\u0003a\u0001}\u0006)Ao\\6f]B\u0019q0!\u0004\u000f\t\u0005\u0005\u0011\u0011\u0002\t\u0004\u0003\u0007QRBAA\u0003\u0015\r\t9aM\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-!$\u0001\u0004Qe\u0016$WMZ\u0005\u0004e\u0006=!bAA\u00065\u0005I\u0001.Y:BG\u000e,7o\u001d\u000b\u0007\u0003+\tY\"!\n\u0011\u0007e\t9\"C\u0002\u0002\u001ai\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u001e)\u0001\r!a\b\u0002\u0015A,'/\\5tg&|g\u000eE\u0002 \u0003CI1!a\t!\u00059AE\u000b\u0016)QKJl\u0017n]:j_:Da!a\n\u000b\u0001\u00041\u0018AC8qi\u0006\u001b7m\\;oi\u0006Q\u0001/\u001e2mS\u000ed\u0015n\u001d;\u0016\u0005\u00055\u0002#B@\u00020\u0005}\u0011\u0002BA\u0019\u0003\u001f\u00111aU3u\u00031awn\\6va\u0006\u001b7-Z:t)\u0011\t9$!\u0012\u0011\te9\u0018\u0011\b\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011qH\n\u0002\u0011\u0015tG/\u001b;jKNLA!a\u0011\u0002>\ta\u0011iY2fgN,e\u000e^5us\")Q\u0010\u0004a\u0001}\"ZA\"!\u0013\u0002V\u0005]\u00131LA/!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA('\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0013\u0011\t\u0019&!\u0014\u0003\u00151{7-\u00197DC\u000eDW-\u0001\u0004qe\u00164\u0017\u000e_\u0011\u0003\u00033\n\u0011\"Y2dKN\u001cx,\u001b3\u0002\u000fQLW.Z8viv\tQ!A\u0007m_>\\W\u000f]!dG>,h\u000e\u001e\u000b\u0004m\u0006\r\u0004bBA3\u001b\u0001\u0007\u0011qM\u0001\nC\u000e\u001cw.\u001e8u\u0013\u0012\u00042!GA5\u0013\r\tYG\u0007\u0002\u0005\u0019>tw\rK\u0006\u000e\u0003\u0013\n)&a\u001c\u0002\\\u0005u\u0013EAA9\u0003)\t7mY8v]R|\u0016\u000e\u001a\u0015\u0004\u0001\u0005U\u0004cA'\u0002x%\u0019\u0011\u0011\u0010(\u0003\u0013MKgn\u001a7fi>t\u0007")
public class DatabaseAuthorizer
implements Authorizer,
HttpVerbs,
PermissionValidation {
    private final Database db;
    private final AccountSQL accountSQL;
    private final AccessSQL accessSQL;
    private final Config conf;
    private final List<String> publiclist;
    private String GET;
    private String POST;
    private String PUT;
    private String PATCH;
    private String DELETE;
    private String HEAD;
    private String OPTIONS;

    @Override
    public boolean validate(HTTPPermission access, HTTPPermission permission) {
        return PermissionValidation.validate$(this, access, permission);
    }

    public String GET() {
        return this.GET;
    }

    public String POST() {
        return this.POST;
    }

    public String PUT() {
        return this.PUT;
    }

    public String PATCH() {
        return this.PATCH;
    }

    public String DELETE() {
        return this.DELETE;
    }

    public String HEAD() {
        return this.HEAD;
    }

    public String OPTIONS() {
        return this.OPTIONS;
    }

    public void play$api$http$HttpVerbs$_setter_$GET_$eq(String x$1) {
        this.GET = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$POST_$eq(String x$1) {
        this.POST = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$PUT_$eq(String x$1) {
        this.PUT = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$PATCH_$eq(String x$1) {
        this.PATCH = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$DELETE_$eq(String x$1) {
        this.DELETE = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$HEAD_$eq(String x$1) {
        this.HEAD = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$OPTIONS_$eq(String x$1) {
        this.OPTIONS = x$1;
    }

    private Config conf() {
        return this.conf;
    }

    private List<String> publiclist() {
        return this.publiclist;
    }

    @Override
    public Option<Account> lookup(String token) {
        return this.lookupAccess(token).flatMap((Function1 & Serializable)a -> this.lookupAccount(a.accountId()));
    }

    @Override
    public boolean hasAccess(HTTPPermission permission, Option<Account> optAccount) {
        if (this.publicList().exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)this.validate(p, permission)))) {
            return true;
        }
        if (optAccount.isEmpty()) {
            return false;
        }
        Account account = (Account)optAccount.get();
        if (account.notAllow()) {
            return false;
        }
        if (((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{AccountRole$.MODULE$.Owner(), AccountRole$.MODULE$.Admin()}))).contains((Object)account.accountRole())) {
            return true;
        }
        return account.permissions().exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)this.validate(p, permission)));
    }

    @Override
    public Set<HTTPPermission> publicList() {
        return this.publiclist().map((Function1 & Serializable)a -> a.split(" ")).map((Function1 & Serializable)a -> new HTTPPermission(a[0], a[1])).toSet();
    }

    @LocalCache(prefix="access_id", timeout=5)
    private Option<AccessEntity> lookupAccess(String token) {
        return (Option)this.db.withConnection((Function1 & Serializable)conn -> $this.accessSQL.get(token, (Connection)conn));
    }

    @LocalCache(prefix="account_id", timeout=5)
    private Option<Account> lookupAccount(long accountId) {
        return (Option)this.db.withConnection((Function1 & Serializable)conn -> $this.accountSQL.get(accountId, (Connection)conn).map((Function1 & Serializable)a -> new Account(Long.toString(a.id()), a.clientId(), a.username(), a.isVerify(), a.isActive(), a.isChangepass(), AccountRole$.MODULE$.apply(a.accountRole()), Account$.MODULE$.apply$default$8(), Account$.MODULE$.apply$default$9(), Account$.MODULE$.apply$default$10())));
    }

    @Inject
    public DatabaseAuthorizer(Database db, AccountSQL accountSQL, AccessSQL accessSQL) {
        this.db = db;
        this.accountSQL = accountSQL;
        this.accessSQL = accessSQL;
        HttpVerbs.$init$((HttpVerbs)this);
        PermissionValidation.$init$(this);
        this.conf = ConfigFactory.load();
        this.publiclist = CollectionConverters$.MODULE$.ListHasAsScala(this.conf().getStringList("yoda.security.publiclist")).asScala().toList();
        Statics.releaseFence();
    }
}

