/*
 * Decompiled with CFR 0.152.
 */
package yoda.security.modules.authorize;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.db.Database;
import play.api.http.HttpVerbs;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import yoda.orm.PStatement;
import yoda.security.annotations.LocalCache;
import yoda.security.definitions.AccountRole$;
import yoda.security.definitions.HTTPMethod$;
import yoda.security.entities.AccessEntity;
import yoda.security.mvc.authorize.Account;
import yoda.security.mvc.authorize.Account$;
import yoda.security.mvc.authorize.Authorizer;
import yoda.security.mvc.authorize.HTTPPermission;
import yoda.security.mvc.authorize.PermissionValidation;
import yoda.security.repositories.AccessSQL;
import yoda.security.repositories.AccountSQL;
import yoda.security.repositories.RoleAccountSQL;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005mf!B\u000b\u0017\u0001aq\u0002\u0002C\u001d\u0001\u0005\u000b\u0007I\u0011B\u001e\t\u0011\u0005\u0003!\u0011!Q\u0001\nqB\u0001B\u0011\u0001\u0003\u0006\u0004%Ia\u0011\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\t\"A1\n\u0001BC\u0002\u0013%A\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003N\u0011!\t\u0006A!b\u0001\n\u0013\u0011\u0006\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u000b]\u0003A\u0011\u0001-\t\u000f!\u0004!\u0019!C\u0005S\"1A\u000f\u0001Q\u0001\n)Dq!\u001e\u0001C\u0002\u0013%a\u000fC\u0004\u0002\u0010\u0001\u0001\u000b\u0011B<\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA)\u0001\u0011\u0005\u00131\u000b\u0005\b\u00037\u0002A\u0011BA/\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003Cq!!$\u0001\t\u0013\ty\tC\u0004\u0002(\u0002!I!!+\u0003%\u0011\u000bG/\u00192bg\u0016\fU\u000f\u001e5pe&TXM\u001d\u0006\u0003/a\t\u0011\"Y;uQ>\u0014\u0018N_3\u000b\u0005eQ\u0012aB7pIVdWm\u001d\u0006\u00037q\t\u0001b]3dkJLG/\u001f\u0006\u0002;\u0005!\u0011p\u001c3b'\u0015\u0001q$\n\u00177!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aEK\u0007\u0002O)\u0011q\u0003\u000b\u0006\u0003Si\t1!\u001c<d\u0013\tYsE\u0001\u0006BkRDwN]5{KJ\u0004\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\t!$H\u000f\u001d\u0006\u0003cI\n1!\u00199j\u0015\u0005\u0019\u0014\u0001\u00029mCfL!!\u000e\u0018\u0003\u0013!#H\u000f\u001d,fe\n\u001c\bC\u0001\u00148\u0013\tAtE\u0001\u000bQKJl\u0017n]:j_:4\u0016\r\\5eCRLwN\\\u0001\u0003I\n\u001c\u0001!F\u0001=!\tit(D\u0001?\u0015\tI\u0004'\u0003\u0002A}\tAA)\u0019;bE\u0006\u001cX-A\u0002eE\u0002\n!\"Y2d_VtGoU)M+\u0005!\u0005CA#I\u001b\u00051%BA$\u001b\u00031\u0011X\r]8tSR|'/[3t\u0013\tIeI\u0001\u0006BG\u000e|WO\u001c;T#2\u000b1\"Y2d_VtGoU)MA\u0005I\u0011mY2fgN\u001c\u0016\u000bT\u000b\u0002\u001bB\u0011QIT\u0005\u0003\u001f\u001a\u0013\u0011\"Q2dKN\u001c8+\u0015'\u0002\u0015\u0005\u001c7-Z:t'Fc\u0005%A\u0003sCN\u000bF*F\u0001T!\t)E+\u0003\u0002V\r\nq!k\u001c7f\u0003\u000e\u001cw.\u001e8u'Fc\u0015A\u0002:b'Fc\u0005%\u0001\u0004=S:LGO\u0010\u000b\u00063ncVL\u0018\t\u00035\u0002i\u0011A\u0006\u0005\u0006s%\u0001\r\u0001\u0010\u0005\u0006\u0005&\u0001\r\u0001\u0012\u0005\u0006\u0017&\u0001\r!\u0014\u0005\u0006#&\u0001\ra\u0015\u0015\u0003\u0013\u0001\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\r%t'.Z2u\u0015\u0005)\u0017!\u00026bm\u0006D\u0018BA4c\u0005\u0019IeN[3di\u0006!1m\u001c8g+\u0005Q\u0007CA6s\u001b\u0005a'BA7o\u0003\u0019\u0019wN\u001c4jO*\u0011q\u000e]\u0001\tif\u0004Xm]1gK*\t\u0011/A\u0002d_6L!a\u001d7\u0003\r\r{gNZ5h\u0003\u0015\u0019wN\u001c4!\u0003)\u0001XO\u00197jG2L7\u000f^\u000b\u0002oB\u0019\u00010`@\u000e\u0003eT!A_>\u0002\u0013%lW.\u001e;bE2,'B\u0001?\"\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003}f\u0014A\u0001T5tiB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001\u00027b]\u001eT!!!\u0003\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\t\u0019A\u0001\u0004TiJLgnZ\u0001\faV\u0014G.[2mSN$\b%\u0001\u0004m_>\\W\u000f\u001d\u000b\u0005\u0003+\t\t\u0003E\u0003!\u0003/\tY\"C\u0002\u0002\u001a\u0005\u0012aa\u00149uS>t\u0007c\u0001\u0014\u0002\u001e%\u0019\u0011qD\u0014\u0003\u000f\u0005\u001b7m\\;oi\"9\u00111\u0005\bA\u0002\u0005\u0015\u0012!\u0002;pW\u0016t\u0007\u0003BA\u0014\u0003kqA!!\u000b\u00022A\u0019\u00111F\u0011\u000e\u0005\u00055\"bAA\u0018u\u00051AH]8pizJ1!a\r\"\u0003\u0019\u0001&/\u001a3fM&!\u0011QBA\u001c\u0015\r\t\u0019$I\u0001\nQ\u0006\u001c\u0018iY2fgN$b!!\u0010\u0002D\u00055\u0003c\u0001\u0011\u0002@%\u0019\u0011\u0011I\u0011\u0003\u000f\t{w\u000e\\3b]\"9\u0011QI\bA\u0002\u0005\u001d\u0013A\u00039fe6L7o]5p]B\u0019a%!\u0013\n\u0007\u0005-sE\u0001\bI)R\u0003\u0006+\u001a:nSN\u001c\u0018n\u001c8\t\u000f\u0005=s\u00021\u0001\u0002\u0016\u0005Qq\u000e\u001d;BG\u000e|WO\u001c;\u0002\u0015A,(\r\\5d\u0019&\u001cH/\u0006\u0002\u0002VA1\u0011qEA,\u0003\u000fJA!!\u0017\u00028\t\u00191+\u001a;\u0002\u0011!\f7OU8mKN$B!a\u0018\u0002hA1\u0011qEA,\u0003C\u00022\u0001IA2\u0013\r\t)'\t\u0002\u0005\u0019>tw\rC\u0004\u0002jE\u0001\r!!\u0019\u0002\u0013\u0005\u001c7m\\;oi&#\u0007fB\t\u0002n\u0005e\u00141\u0010\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111\u000f\u000e\u0002\u0017\u0005tgn\u001c;bi&|gn]\u0005\u0005\u0003o\n\tH\u0001\u0006M_\u000e\fGnQ1dQ\u0016\fa\u0001\u001d:fM&D\u0018EAA?\u00031\u0011x\u000e\\3`C\u000e\u001cw.\u001e8u\u0003%\tG\u000e\\8x\u0019&\u001cH\u000f\u0006\u0003\u0002V\u0005\r\u0005bBAC%\u0001\u0007\u0011qL\u0001\be>dW-\u00133tQ\u001d\u0011\u0012QNA=\u0003\u0013\u000b#!a#\u0002\u001fI|G.Z0qKJl\u0017n]:j_:\fA\u0002\\8pWV\u0004\u0018iY2fgN$B!!%\u0002 B)\u0001%a\u0006\u0002\u0014B!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001aj\t\u0001\"\u001a8uSRLWm]\u0005\u0005\u0003;\u000b9J\u0001\u0007BG\u000e,7o]#oi&$\u0018\u0010C\u0004\u0002$M\u0001\r!!\n)\u000fM\ti'!\u001f\u0002$\u0006\u0012\u0011QU\u0001\nC\u000e\u001cWm]:`S\u0012\fQ\u0002\\8pWV\u0004\u0018iY2pk:$H\u0003BA\u000b\u0003WCq!!\u001b\u0015\u0001\u0004\t\t\u0007K\u0004\u0015\u0003[\nI(a,\"\u0005\u0005E\u0016AC1dG>,h\u000e^0jI\"\u001a\u0001!!.\u0011\u0007\u0005\f9,C\u0002\u0002:\n\u0014\u0011bU5oO2,Go\u001c8")
public class DatabaseAuthorizer
implements Authorizer,
HttpVerbs,
PermissionValidation {
    private final Database db;
    private final AccountSQL accountSQL;
    private final AccessSQL accessSQL;
    private final RoleAccountSQL raSQL;
    private final Config conf;
    private final List<String> publiclist;
    private String GET;
    private String POST;
    private String PUT;
    private String PATCH;
    private String DELETE;
    private String HEAD;
    private String OPTIONS;

    @Override
    public boolean validate(HTTPPermission access, HTTPPermission permission) {
        return PermissionValidation.validate$(this, access, permission);
    }

    public String GET() {
        return this.GET;
    }

    public String POST() {
        return this.POST;
    }

    public String PUT() {
        return this.PUT;
    }

    public String PATCH() {
        return this.PATCH;
    }

    public String DELETE() {
        return this.DELETE;
    }

    public String HEAD() {
        return this.HEAD;
    }

    public String OPTIONS() {
        return this.OPTIONS;
    }

    public void play$api$http$HttpVerbs$_setter_$GET_$eq(String x$1) {
        this.GET = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$POST_$eq(String x$1) {
        this.POST = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$PUT_$eq(String x$1) {
        this.PUT = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$PATCH_$eq(String x$1) {
        this.PATCH = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$DELETE_$eq(String x$1) {
        this.DELETE = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$HEAD_$eq(String x$1) {
        this.HEAD = x$1;
    }

    public void play$api$http$HttpVerbs$_setter_$OPTIONS_$eq(String x$1) {
        this.OPTIONS = x$1;
    }

    private Database db() {
        return this.db;
    }

    private AccountSQL accountSQL() {
        return this.accountSQL;
    }

    private AccessSQL accessSQL() {
        return this.accessSQL;
    }

    private RoleAccountSQL raSQL() {
        return this.raSQL;
    }

    private Config conf() {
        return this.conf;
    }

    private List<String> publiclist() {
        return this.publiclist;
    }

    @Override
    public Option<Account> lookup(String token) {
        return this.lookupAccess(token).flatMap((Function1 & Serializable)a -> this.lookupAccount(a.accountId()));
    }

    @Override
    public boolean hasAccess(HTTPPermission permission, Option<Account> optAccount) {
        if (this.publicList().exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)this.validate(p, permission)))) {
            return true;
        }
        if (optAccount.isEmpty() || ((Account)optAccount.get()).notAllow()) {
            return false;
        }
        Account account = (Account)optAccount.get();
        Set roles = (Set)this.hasRoles(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(account.id()))).$plus((Object)BoxesRunTime.boxToLong((long)0L));
        if (((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{AccountRole$.MODULE$.Owner(), AccountRole$.MODULE$.Admin()}))).contains((Object)account.accountRole()) || this.allowList((Set<Object>)roles).exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)this.validate(p, permission)))) {
            return true;
        }
        return account.permissions().exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)this.validate(p, permission)));
    }

    @Override
    public Set<HTTPPermission> publicList() {
        return this.publiclist().map((Function1 & Serializable)a -> a.split(" ")).map((Function1 & Serializable)a -> new HTTPPermission(a[0], a[1])).toSet();
    }

    @LocalCache(prefix="role_account")
    private Set<Object> hasRoles(long accountId) {
        return (Set)this.db().withConnection((Function1 & Serializable)conn -> this.raSQL().findBy(accountId, (Connection)conn).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.roleId())).toSet());
    }

    @LocalCache(prefix="role_permission")
    private Set<HTTPPermission> allowList(Set<Object> roleIds) {
        return (Set)this.db().withConnection((Function1 & Serializable)conn -> {
            PStatement p = new PStatement(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |SELECT  p.method_id, p.endpoint\n          |FROM    role_permission rp\n          |    INNER JOIN permissions p on rp.permission_id = p.id\n          |WHERE   rp.role_id = ?;\n          |")), conn);
            return (Set)roleIds.flatMap((Function1 & Serializable)roleId -> DatabaseAuthorizer.$anonfun$allowList$2(p, BoxesRunTime.unboxToLong((Object)roleId)));
        });
    }

    @LocalCache(prefix="access_id")
    private Option<AccessEntity> lookupAccess(String token) {
        return (Option)this.db().withConnection((Function1 & Serializable)conn -> this.accessSQL().get(token, (Connection)conn));
    }

    @LocalCache(prefix="account_id")
    private Option<Account> lookupAccount(long accountId) {
        return (Option)this.db().withConnection((Function1 & Serializable)conn -> this.accountSQL().get(accountId, (Connection)conn).map((Function1 & Serializable)a -> new Account(Long.toString(a.id()), a.clientId(), a.username(), a.isVerify(), a.isActive(), a.isChangepass(), AccountRole$.MODULE$.apply(a.accountRole()), Account$.MODULE$.apply$default$8(), Account$.MODULE$.apply$default$9(), Account$.MODULE$.apply$default$10())));
    }

    public static final /* synthetic */ List $anonfun$allowList$2(PStatement p$1, long roleId) {
        return p$1.setLong(roleId).queryList((Function1 & Serializable)rs -> new HTTPPermission(HTTPMethod$.MODULE$.apply(rs.getInt("method_id")).toString(), rs.getString("endpoint")));
    }

    @Inject
    public DatabaseAuthorizer(Database db, AccountSQL accountSQL, AccessSQL accessSQL, RoleAccountSQL raSQL) {
        this.db = db;
        this.accountSQL = accountSQL;
        this.accessSQL = accessSQL;
        this.raSQL = raSQL;
        HttpVerbs.$init$((HttpVerbs)this);
        PermissionValidation.$init$(this);
        this.conf = ConfigFactory.load();
        this.publiclist = CollectionConverters$.MODULE$.ListHasAsScala(this.conf().getStringList("yoda.security.publiclist")).asScala().toList();
        Statics.releaseFence();
    }
}

