package com.payu.paymentparamhelper.siparams;

import android.os.Parcel;
import android.os.Parcelable;

public class SIParams  implements Parcelable {
    private String api_vesrion = "7";
    private String si = "1";
    private boolean free_trial;

    private SIParamsDetails si_details;


    private String ccCardType; // example: CC/DC
    private String ccCategory; //example: MAST, VISA etc

    //To be filled in case of netbanking
    private BeneficiaryDetails beneficiarydetail;

    public SIParams() {
    }

    protected SIParams(Parcel in) {
        api_vesrion = in.readString();
        si = in.readString();
        free_trial = in.readByte() != 0;
        si_details = in.readParcelable(SIParamsDetails.class.getClassLoader());
        beneficiarydetail = in.readParcelable(BeneficiaryDetails.class.getClassLoader());
        ccCardType = in.readString();
        ccCategory = in.readString();
    }

    public static final Creator<SIParams> CREATOR = new Creator<SIParams>() {
        @Override
        public SIParams createFromParcel(Parcel in) {
            return new SIParams(in);
        }

        @Override
        public SIParams[] newArray(int size) {
            return new SIParams[size];
        }
    };

    public String getApi_vesrion() {
        return api_vesrion;
    }

    public String getSi() {
        return si;
    }

    public boolean isFree_trial() {
        return free_trial;
    }

    public void setFree_trial(boolean free_trial) {
        this.free_trial = free_trial;
    }

    public void setApi_vesrion(String api_vesrion) {
        this.api_vesrion = api_vesrion;
    }

    public void setSi(String si) {
        this.si = si;
    }

    public SIParamsDetails getSi_details() {
        return si_details;
    }

    public void setSi_details(SIParamsDetails si_details) {
        this.si_details = si_details;
    }

    public BeneficiaryDetails getBeneficiarydetail() {
        return beneficiarydetail;
    }

    public void setBeneficiarydetail(BeneficiaryDetails beneficiarydetail) {
        this.beneficiarydetail = beneficiarydetail;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(api_vesrion);
        dest.writeString(si);
        dest.writeByte((byte) (free_trial ? 1 : 0));
        dest.writeParcelable(si_details, flags);
        dest.writeParcelable(beneficiarydetail, flags);
        dest.writeString(ccCardType);
        dest.writeString(ccCategory);
    }


    public String getCcCardType() {
        return ccCardType;
    }

    public void setCcCardType(String ccCardType) {
        this.ccCardType = ccCardType;
    }

    public String getCcCategory() {
        return ccCategory;
    }

    public void setCcCategory(String ccCategory) {
        this.ccCategory = ccCategory;
    }
}