package com.payu.paymentparamhelper;

import android.util.Base64;
import android.util.Pair;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class EncryptionUtils {
    private static final String RSA_ECB_ALGORITHM = "RSA/ECB/PKCS1Padding";

    private static final int KEY_SIZE = 256;
    private static final int IV_SIZE = 12;
    private static final int TAG_LENGTH = 128;


    // Generate a new AES key
    public static SecretKey generateKey() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(KEY_SIZE);
        return keyGen.generateKey();

    }

    // Encrypt otp and MPin for setMPin Request
    public static SetMPinEncryptedInfo encrypt(String otp, String mPin, String pubKeyValue) throws Exception {
        SecretKey key = generateKey();
        PublicKey publicKey = EncryptionUtils.getPublicKey(pubKeyValue);

        String encryptedKey = EncryptionUtils.encryptDataUsingRsa(key, publicKey);
        byte[] iv = generateIV();

        String encryptedOtp = getEncryptedValue(key, otp, iv);
        byte[] ivMPin = generateIV();
        String encryptedMPin = getEncryptedValue(key, mPin, ivMPin);
        SetMPinEncryptedInfo setMPinEncryptedInfo = new SetMPinEncryptedInfo();
        setMPinEncryptedInfo.setmPin(encryptedMPin);
        setMPinEncryptedInfo.setOtp(encryptedOtp);
        setMPinEncryptedInfo.setEncryptedAesKey(encryptedKey);
        return setMPinEncryptedInfo;

    }

    // Encrypt  MPin for verifyMPin Request
    public static SetMPinEncryptedInfo encrypt(String mPin) throws Exception {
        SecretKey key = generateKey();
        PublicKey publicKey = EncryptionUtils.getPublicKey(PayuConstants.PayuLoyalityConstant.subPart1 + PayuConstants.PayuLoyalityConstant.subPart2 + PayuConstants.PayuLoyalityConstant.subPart3);

        String encryptedKey = EncryptionUtils.encryptDataUsingRsa(key, publicKey);
        byte[] iv = generateIV();
        String encryptedMPin = getEncryptedValue(key, mPin, iv);
        SetMPinEncryptedInfo setMPinEncryptedInfo = new SetMPinEncryptedInfo();
        setMPinEncryptedInfo.setmPin(encryptedMPin);
        setMPinEncryptedInfo.setEncryptedAesKey(encryptedKey);
        return setMPinEncryptedInfo;
    }

    private static String getEncryptedValue(SecretKey key, String plainText, byte[] iv) throws IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        if (plainText == null) return null;
        Cipher cipher = Cipher.getInstance(PayuConstants.PAYU_AES_GCM_NO_PADDING);
        GCMParameterSpec spec = new GCMParameterSpec(TAG_LENGTH, iv);
        cipher.init(Cipher.ENCRYPT_MODE, key, spec);
        byte[] encrypted = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
        ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + encrypted.length);
        byteBuffer.put(iv);
        byteBuffer.put(encrypted);
        return Base64.encodeToString(byteBuffer.array(), Base64.NO_WRAP);
    }


    // Generate random IV
    public static byte[] generateIV() {
        byte[] iv = new byte[IV_SIZE];
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    /**
     * Alternative method that accepts a PublicKey object directly
     * instead of a string representation
     */

    public static PublicKey getPublicKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = Base64.decode(key, Base64.NO_WRAP);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        return KeyFactory.getInstance(PayuConstants.PAYU_RSA).generatePublic(spec);
    }


    // method to encrypt aesKey with rsa algo
    public static String encryptDataUsingRsa(SecretKey data, PublicKey publicKey) throws Exception {
        byte[] rawKey = data.getEncoded();
        String key = android.util.Base64.encodeToString(rawKey, android.util.Base64.NO_WRAP);
        Cipher cipher = Cipher.getInstance(RSA_ECB_ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, publicKey);
        byte[] encryptedData = cipher.doFinal(key.getBytes(StandardCharsets.UTF_8));
        return android.util.Base64.encodeToString(encryptedData, android.util.Base64.NO_WRAP);
    }

}
