package com.payu.india.Interfaces;

import com.payu.india.Model.ApiResponse;
import com.payu.india.Model.CalculateEmiRequest;
import com.payu.india.Model.DeviceIdRequest;
import com.payu.india.Model.FetchOffer.FetchOfferApiRequest;
import com.payu.india.Model.QuickPay.GlobalVaultOTPRequest;
import com.payu.india.Model.QuickPay.GlobalVaultVerifyOTPRequest;
import com.payu.india.Model.QuickPay.QuickPayRequest;
import com.payu.india.Model.binBaseDetails.BinBaseDetailsRequest;
import com.payu.india.Model.binBaseDetails.BinBaseDetailsResponse;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeRequest;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeResponse;
import com.payu.india.Model.validateOffer.ValidateOfferRequest;
import com.payu.india.Model.adsinformation.AdsApiRequest;
import com.payu.india.Model.adsinformation.AdsImpressionApiRequest;
import com.payu.india.Model.adsinformation.AdsPayUIdApiRequest;

import java.util.HashMap;

public interface V2APITaskListener {
    void getOffers(FetchOfferApiRequest fetchOfferApiRequest, HashGenerationListener hashGenerationListener, FetchOfferDetailsListener fetchOfferDetailsListener);

    void validateOffers(ValidateOfferRequest validateOfferRequest, HashGenerationListener hashGenerationListener, ValidateOfferApiListener validateOfferApiListener);

    void getAdsDetails(AdsApiRequest adsApiRequest, FetchAdsInformationApiListener fetchAdsInformationApiListener);

    void postAdsImpressionEvent(AdsImpressionApiRequest adsImpressionApiRequest);

    void updateAdsPayUId(AdsPayUIdApiRequest adsPayUIdApiRequest);

    void getQuickPayOptions(QuickPayRequest quickPayRequest, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener);

    void getEmiCalculator(CalculateEmiRequest calculateEmiRequest, HashGenerationListener hashGenerationListener, OnEmiCalculaterListener onEmiCalculaterListener);

    void updateDeviceId(DeviceIdRequest deviceIdRequest, HashGenerationListener hashGenerationListener);

    void globalVaultSendOTP(final GlobalVaultOTPRequest globalVaultRequest, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener);

    void globalVaultResendOTP(final GlobalVaultOTPRequest globalVaultRequest, HashMap<String, String> map, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener);

    void globalVaultVerifyOTP(final GlobalVaultVerifyOTPRequest globalVaultRequest, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener);

    void fetchIfscDetails(String ifscCode, HashGenerationListener hashGenerationListener, FetchIFSCDetailsListener fetchIFSCDetailsListener);

    void getBinBaseDetails(final BinBaseDetailsRequest binBaseDetailsRequest, HashGenerationListener hashGenerationListener, V2ApiResponseListener<ApiResponse<BinBaseDetailsResponse>> v2ApiResponseListener);

    void fetchConvFeeDetails(final FetchConvFeeRequest fetchConvFeeRequest, HashGenerationListener hashGenerationListener, V2ApiResponseListener<ApiResponse<FetchConvFeeResponse>> v2ApiResponseListener);
}
