package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;

public class EMIOptionInOffers implements Parcelable {
    private String bankCode;
    private String emiType;
    private ArrayList<PaymentOptionOfferinfo> paymentOptionOfferinfoArrayList;

    protected EMIOptionInOffers(Parcel in) {
        bankCode = in.readString();
        emiType = in.readString();
        paymentOptionOfferinfoArrayList = in.createTypedArrayList(PaymentOptionOfferinfo.CREATOR);
    }

    public EMIOptionInOffers() {

    }

    public static final Creator<EMIOptionInOffers> CREATOR = new Creator<EMIOptionInOffers>() {
        @Override
        public EMIOptionInOffers createFromParcel(Parcel in) {
            return new EMIOptionInOffers(in);
        }

        @Override
        public EMIOptionInOffers[] newArray(int size) {
            return new EMIOptionInOffers[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(bankCode);
        parcel.writeString(emiType);
        parcel.writeTypedList(paymentOptionOfferinfoArrayList);
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getEmiType() {
        return emiType;
    }

    public void setEmiType(String emiType) {
        this.emiType = emiType;
    }

    public ArrayList<PaymentOptionOfferinfo> getPaymentOptionOfferinfoArrayList() {
        return paymentOptionOfferinfoArrayList;
    }

    public void setPaymentOptionOfferinfoArrayList(ArrayList<PaymentOptionOfferinfo> paymentOptionOfferinfoArrayList) {
        this.paymentOptionOfferinfoArrayList = paymentOptionOfferinfoArrayList;
    }
}
