package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import com.payu.india.Tasks.FetchIFSCDetailsTask;

/**
 * Simple bean implementation of IFSC Details
 * When the app uses {@link FetchIFSCDetailsTask} the response will be passed as {@link IFSCCodeDetails}
 * along with the {@link PostData} in {@link PayuResponse}
 */
public class IFSCCodeDetails implements Parcelable {

    private String bank;
    private String city;
    private String ifsc;
    private String micr;
    private String state;
    private String branch;
    private String office;
    private String address;
    private String contact;
    private String district;

    public String getBank() {
        return bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getIfsc() {
        return ifsc;
    }

    public void setIfsc(String ifsc) {
        this.ifsc = ifsc;
    }

    public String getMicr() {
        return micr;
    }

    public void setMicr(String micr) {
        this.micr = micr;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getBranch() {
        return branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getOffice() {
        return office;
    }

    public void setOffice(String office) {
        this.office = office;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public IFSCCodeDetails() {
    }

    protected IFSCCodeDetails(Parcel in) {
        bank = in.readString();
        city = in.readString();
        ifsc = in.readString();
        micr = in.readString();
        state = in.readString();
        branch = in.readString();
        office = in.readString();
        address = in.readString();
        contact = in.readString();
        district = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(bank);
        dest.writeString(city);
        dest.writeString(ifsc);
        dest.writeString(micr);
        dest.writeString(state);
        dest.writeString(branch);
        dest.writeString(office);
        dest.writeString(address);
        dest.writeString(contact);
        dest.writeString(district);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<IFSCCodeDetails> CREATOR = new Creator<IFSCCodeDetails>() {
        @Override
        public IFSCCodeDetails createFromParcel(Parcel in) {
            return new IFSCCodeDetails(in);
        }

        @Override
        public IFSCCodeDetails[] newArray(int size) {
            return new IFSCCodeDetails[size];
        }
    };
}
