package com.payu.india.Model.Olw;

import android.util.Log;

import com.payu.india.Payu.PayuConstants;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONException;
import org.json.JSONObject;

public class SendOtpRequest extends V2ApiBase {
  private final String clientTxnId;
  private final String requestDateTime;
  private final String customerMobile;


  // Private constructor - only the Builder can create instances
  private SendOtpRequest(Builder builder) {
    this.clientTxnId = builder.clientTxnId;
    this.requestDateTime = builder.requestDateTime;
    this.customerMobile = builder.customerMobile;
  }

  // Getters - no setters as the object is immutable
  public String getClientTxnId() {
    return this.clientTxnId;
  }

  public String getRequestDateTime() {
    return this.requestDateTime;
  }

  public String getCustomerMobile() {
    return this.customerMobile;
  }

  @Override
  public String getJson() {
    JSONObject jsonObject = new JSONObject();
    try {
      jsonObject.put(PayuConstants.PAYU_CLIENT_TXN_ID, clientTxnId);
      jsonObject.put(PayuConstants.PAYU_REQUEST_DATE_TIME, requestDateTime);
      jsonObject.put(PayuConstants.PAYU_CUSTOMER_MOBILE, customerMobile);
    } catch (JSONException e) {
      Log.d("QuickPayRequest", "Exception " + e.getMessage());
    }
    return jsonObject.toString();
  }

  // Static Builder class
  public static class Builder {
    private String clientTxnId;
    private String requestDateTime;
    private String customerMobile;

    public Builder setClientTxnId(String clientTxnId) {
      this.clientTxnId = clientTxnId;
      return this;
    }

    public Builder setRequestDateTime(String requestDateTime) {
      this.requestDateTime = requestDateTime;
      return this;
    }

    public Builder setCustomerMobile(String customerMobile) {
      this.customerMobile = customerMobile;
      return this;
    }


    public SendOtpRequest build() {
      return new SendOtpRequest(this);
    }
  }
}

