package com.payu.india.Model;

import android.util.Log;

import com.payu.india.Payu.PayuConstants;

import org.json.JSONException;
import org.json.JSONObject;

public class Usecase {

    private final boolean getAdditionalCharges;
    private final boolean getTaxSpecification;
    private final boolean checkDownStatus;
    private final boolean getOfferDetails;
    private final boolean getExtendedPaymentDetails;
    private final boolean checkCustomerEligibility;
    private final boolean getMerchantDetails;
    private final boolean getPaymentDetailsWithExtraFields;
    private final boolean getSdkDetails;

    private Usecase(Builder builder) {
        this.getAdditionalCharges = builder.getAdditionalCharges;
        this.getTaxSpecification = builder.getTaxSpecification;
        this.checkDownStatus = builder.checkDownStatus;
        this.getOfferDetails = builder.getOfferDetails;
        this.getExtendedPaymentDetails = builder.getExtendedPaymentDetails;
        this.checkCustomerEligibility = builder.checkCustomerEligibility;
        this.getMerchantDetails = builder.getMerchantDetails;
        this.getPaymentDetailsWithExtraFields = builder.getPaymentDetailsWithExtraFields;
        this.getSdkDetails = builder.getSdkDetails;

    }

    public JSONObject prepareUseCaseJson() {
        JSONObject useCase = new JSONObject();
        try {
            if (getAdditionalCharges)
                useCase.put(PayuConstants.P_GET_ADDITIONAL_CHARGES, getAdditionalCharges);

            if (getTaxSpecification)
                useCase.put(PayuConstants.P_GET_TAX_SPECIFICATION, getTaxSpecification);

            if (checkDownStatus)
                useCase.put(PayuConstants.P_CHECK_DOWN_STATUS, checkDownStatus);

            if (getOfferDetails)
                useCase.put(PayuConstants.P_GET_OFFER_DETAILS, getOfferDetails);

            if (getExtendedPaymentDetails)
                useCase.put(PayuConstants.P_GET_EXTENDED_PAYMENT_DETAILS, getExtendedPaymentDetails);

            if (checkCustomerEligibility)
                useCase.put(PayuConstants.P_CHECKCUSTOMER_ELIGIBILITY, checkCustomerEligibility);

            if (getMerchantDetails)
                useCase.put(PayuConstants.P_GET_MERCHANT_DETAILS, getMerchantDetails);

            if (getPaymentDetailsWithExtraFields)
                useCase.put(PayuConstants.P_GET_PAYMENT_DETAILS_WITH_EXTRA_FIELDS, getPaymentDetailsWithExtraFields);

            if (getSdkDetails)
                useCase.put(PayuConstants.P_GET_SDK_DETAILS, true);

        } catch (JSONException e) {
            Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
        }
        return useCase;
    }

    public static class Builder {
        private boolean getAdditionalCharges;
        private boolean getTaxSpecification;
        private boolean checkDownStatus;
        private boolean getOfferDetails;
        private boolean getExtendedPaymentDetails;
        private boolean checkCustomerEligibility;
        private boolean getMerchantDetails;
        private boolean getPaymentDetailsWithExtraFields;
        private boolean getSdkDetails;

        public Builder shouldGetAdditionalCharges(boolean getAdditionalCharges) {
            this.getAdditionalCharges = getAdditionalCharges;
            return this;
        }

        public Builder shouldGetExtendedPaymentDetails(boolean getExtendedPaymentDetails) {
            this.getExtendedPaymentDetails = getExtendedPaymentDetails;
            return this;
        }

        public Builder shouldGetOfferDetails(boolean getOfferDetails) {
            this.getOfferDetails = getOfferDetails;
            return this;
        }

        public Builder shouldCheckDownStatus(boolean checkDownStatus) {
            this.checkDownStatus = checkDownStatus;
            return this;
        }

        public Builder shouldGetTaxSpecification(boolean getTaxSpecification) {
            this.getTaxSpecification = getTaxSpecification;
            return this;
        }

        public Builder setCheckCustomerEligibility(Boolean checkCustomerEligibility) {
            this.checkCustomerEligibility = checkCustomerEligibility;
            return this;
        }

        public Builder shouldGetMerchantDetails(boolean getMerchantDetails) {
            this.getMerchantDetails = getMerchantDetails;
            return this;
        }

        public Builder shouldGetPaymentDetailsWithExtraFields(boolean getPaymentDetailsWithExtraFields) {
            this.getPaymentDetailsWithExtraFields = getPaymentDetailsWithExtraFields;
            return this;
        }

        public Builder shouldGetSdkDetails(boolean getSdkDetails) {
            this.getSdkDetails = getSdkDetails;
            return this;
        }

        public Usecase build() {
            return new Usecase(this);
        }

    }

}
