package com.payu.india.Model.validateOffer;

import android.os.Parcel;
import android.os.Parcelable;
import com.payu.india.Model.ValidateOfferInfo;
import com.payu.paymentparamhelper.Sku;
import com.payu.paymentparamhelper.SkuDiscountDetails;
import java.util.List;

public class SKUOfferDetails implements Parcelable {

    private List<ValidateOfferInfo> validateOfferInfoList;
    private boolean isValid;
    private Sku sku;
    private SkuDiscountDetails skuDiscountDetails;


    public SKUOfferDetails() {

    }

    protected SKUOfferDetails(Parcel in) {
        validateOfferInfoList = in.createTypedArrayList(ValidateOfferInfo.CREATOR);
        isValid = in.readByte() != 0;
        sku = in.readParcelable(Sku.class.getClassLoader());
        skuDiscountDetails = in.readParcelable(SkuDiscountDetails.class.getClassLoader());
    }

    public static final Creator<SKUOfferDetails> CREATOR = new Creator<SKUOfferDetails>() {
        @Override
        public SKUOfferDetails createFromParcel(Parcel in) {
            return new SKUOfferDetails(in);
        }

        @Override
        public SKUOfferDetails[] newArray(int size) {
            return new SKUOfferDetails[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeTypedList(validateOfferInfoList);
        parcel.writeByte((byte) (isValid ? 1 : 0));
        parcel.writeParcelable(sku, i);
    }

    public boolean isValid() {
        return isValid;
    }

    public void setValid(boolean valid) {
        isValid = valid;
    }

    public Sku getSku() {
        return sku;
    }

    public void setSku(Sku sku) {
        this.sku = sku;
    }
    public SkuDiscountDetails getSkuDiscountDetails() {
        return skuDiscountDetails;
    }

    public void setSkuDiscountDetails(SkuDiscountDetails skuDiscountDetails) {
        this.skuDiscountDetails = skuDiscountDetails;
    }

    public List<ValidateOfferInfo> getValidateOfferInfoList() {
        return validateOfferInfoList;
    }

    public void setValidateOfferInfoList(List<ValidateOfferInfo> validateOfferInfoList) {
        this.validateOfferInfoList = validateOfferInfoList;
    }
}
