package com.payu.india.Model.validateOffer;

import android.os.Parcel;
import android.os.Parcelable;

import com.payu.india.Model.ValidateOfferInfo;

import java.util.List;

public class ValidateOfferDetails implements Parcelable {

    private double amount;
    private double totalCashbackDiscount;
    private double totalInstantDiscount;
    private double totalDiscountedAmount;
    private List<ValidateOfferInfo> validateOfferInfoList;
    private List<SKUOfferDetails> skuOfferDetailsList;
    private String failureReason;
    private boolean autoApply;
    private boolean isValid;


    public ValidateOfferDetails() {
    }

    public double getAmount() {
        return amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }


    public String getFailureReason() {
        return failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public List<ValidateOfferInfo> getValidateOfferInfo() {
        return validateOfferInfoList;
    }

    public void setValidateOfferInfo(List<ValidateOfferInfo> validateOfferInfo) {
        this.validateOfferInfoList = validateOfferInfo;
    }

    public double getTotalCashbackDiscount() {
        return totalCashbackDiscount;
    }

    public void setTotalCashbackDiscount(double totalCashbackDiscount) {
        this.totalCashbackDiscount = totalCashbackDiscount;
    }

    public double getTotalInstantDiscount() {
        return totalInstantDiscount;
    }

    public void setTotalInstantDiscount(double totalInstantDiscount) {
        this.totalInstantDiscount = totalInstantDiscount;
    }

    public double getTotalDiscountedAmount() {
        return totalDiscountedAmount;
    }

    public void setTotalDiscountedAmount(double totalDiscountedAmount) {
        this.totalDiscountedAmount = totalDiscountedAmount;
    }

    public List<SKUOfferDetails> getSkuOfferDetailsList() {
        return skuOfferDetailsList;
    }

    public void setSkuOfferDetailsList(List<SKUOfferDetails> skuOfferDetailsList) {
        this.skuOfferDetailsList = skuOfferDetailsList;
    }

    public boolean isAutoApply() {
        return autoApply;
    }

    public void setAutoApply(boolean autoApply) {
        this.autoApply = autoApply;
    }

    public boolean isValid() {
        return isValid;
    }

    public void setValid(boolean valid) {
        isValid = valid;
    }

    protected ValidateOfferDetails(Parcel in) {
        amount = in.readInt();
        validateOfferInfoList = in.createTypedArrayList(ValidateOfferInfo.CREATOR);
        totalCashbackDiscount = in.readDouble();
        totalInstantDiscount = in.readDouble();
        totalDiscountedAmount = in.readDouble();
        skuOfferDetailsList = in.createTypedArrayList(SKUOfferDetails.CREATOR);
        failureReason = in.readString();
        autoApply = in.readByte() != 0;
        isValid = in.readByte() != 0;
    }

    public static final Creator<ValidateOfferDetails> CREATOR = new Creator<ValidateOfferDetails>() {
        @Override
        public ValidateOfferDetails createFromParcel(Parcel in) {
            return new ValidateOfferDetails(in);
        }

        @Override
        public ValidateOfferDetails[] newArray(int size) {
            return new ValidateOfferDetails[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeDouble(amount);
        parcel.writeTypedList(validateOfferInfoList);
        parcel.writeDouble(totalCashbackDiscount);
        parcel.writeDouble(totalInstantDiscount);
        parcel.writeDouble(totalDiscountedAmount);
        parcel.writeTypedList(skuOfferDetailsList);
        parcel.writeString(failureReason);
        parcel.writeByte((byte) (autoApply ? 1 : 0));
        parcel.writeByte((byte) (isValid ? 1 : 0));
    }
}
