package com.payu.india.Tasks;

import android.util.Log;

import com.payu.india.Interfaces.V2ApiResponseListener;
import com.payu.india.Model.ApiResponse;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PostData;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeResponse;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Payu.v2ApiResponseParser.V2ApiResponseParser;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

public class FetchConvFeeTask extends PayUAsyncTask<PayuConfig, String, ApiResponse<FetchConvFeeResponse>> {

    private final String TAG = this.getClass().getSimpleName();
    private final V2ApiResponseListener<ApiResponse<FetchConvFeeResponse>> v2ApiResponseListener;

    public FetchConvFeeTask(V2ApiResponseListener<ApiResponse<FetchConvFeeResponse>> v2ApiResponseListener){
        this.v2ApiResponseListener = v2ApiResponseListener;
    }
    @Override
    protected ApiResponse<FetchConvFeeResponse> doInBackground(PayuConfig... params) {
        Log.d(TAG, "doInBackground");
        ApiResponse<FetchConvFeeResponse> apiResponse = new ApiResponse<>();
        PostData postData = new PostData();
        InputStream responseInputStream = null;


        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];
            // set the environment
            //Todo: To be changed later
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_APIV2_URL);
                    break;
                default:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
            }

            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).
                    setURL(url + PayuConstants.PAYU_FETCH_CONV_FEE).setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader(PayuConstants.PAYU_FETCH_CONV_F)).
                    setRequestType(PayuConstants.REQUEST_APPLICATION_JSON).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
//
            if (null != conn) {
                responseInputStream = conn.getInputStream();
                StringBuilder responseStringBuffer = new StringBuilder();
                byte[] byteContainer = new byte[1024];
                for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }

                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                apiResponse.setRawResponse(jsonResponse);
                new V2ApiResponseParser().parseFetchConvFeeResponse(jsonResponse, apiResponse);
            }
        } catch (MalformedURLException e) {
            Log.d(TAG, " MalformedURLException" + e.getMessage());
            postData.setCode(PayuErrors.MALFORMED_URL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (IOException e) {
            Log.d(TAG, " MalformedURLException" + e.getMessage());
            postData.setCode(PayuErrors.IO_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (JSONException e) {
            Log.d(TAG, " JSONException" + e.getMessage());
            postData.setCode(PayuErrors.JSON_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } finally {
            if (responseInputStream != null)
                PayuUtils.safeClose(responseInputStream);
        }
        apiResponse.setPostData(postData);
        return apiResponse;
    }

    @Override
    protected void onPostExecute(ApiResponse<FetchConvFeeResponse> apiResponse) {
        super.onPostExecute(apiResponse);
        v2ApiResponseListener.onApiResponse(apiResponse);
    }
}
