package com.payu.upiboltcore

import com.payu.upiboltcore.models.DeviceRegistrationStatus
import com.payu.upiboltcore.models.PayUPluginInitParams
import okhttp3.Call

internal object InternalConfig {

    var deviceRegistrationStatus: DeviceRegistrationStatus? = null
    var clientId: String? = null
    var sdkInitParams: PayUPluginInitParams? = null
    var pspRespRefNo: String? = null
    var issuingBanks: List<String> = listOf()
    var isProduction: Boolean = true
    var registeredAccountsMap: HashMap<String, String?>? = null
    val activeApiCalls = ArrayList<Call?>()
    var initSdkId: String? = null
    var otpAttempts: Int? = 0

    fun clearAll() {
        deviceRegistrationStatus = null
        clientId = null
        sdkInitParams = null
        registeredAccountsMap?.clear()
        pspRespRefNo = null
        activeApiCalls.clear()
        initSdkId = null
        otpAttempts = null
    }
}