package com.payu.upiboltcore

import androidx.fragment.app.FragmentActivity
import com.payu.upiboltcore.features.management.ManagementRepository
import com.payu.upiboltcore.features.management.ManagementServiceImpl
import com.payu.upiboltcore.features.registration.RegistrationRepository
import com.payu.upiboltcore.features.registration.RegistrationServiceImpl
import com.payu.upiboltcore.features.transaction.TransactionRepository
import com.payu.upiboltcore.features.transaction.TransactionServiceImpl
import com.payu.upiboltcore.interfaces.TransactionService
import com.payu.upiboltcore.interfaces.ManagementService
import com.payu.upiboltcore.interfaces.RegistrationService
import com.payu.upiboltcore.network.CommonHeaders
import com.payu.upiboltcore.network.UpiCoreApiService
import com.payu.upiboltcore.npci.AppUPIRegistrationManager
import com.payu.upiboltcore.npci.CLCredentialManager

internal object PluginServiceLocator {

    fun getRegistrationService(
        activity: FragmentActivity,
        appUPIRegistrationManager: AppUPIRegistrationManager
    ): RegistrationService =
        RegistrationServiceImpl(
            activity,
            RegistrationRepository(CommonHeaders(), UpiCoreApiService()),
            appUPIRegistrationManager
        )

    fun getManagementService(
        activity: FragmentActivity,
        credentialManager: CLCredentialManager
    ): ManagementService =
        ManagementServiceImpl(
            activity,
            ManagementRepository(CommonHeaders(), UpiCoreApiService()),
            credentialManager
        )

    fun getTransactionService(
        activity: FragmentActivity,
        credentialManager: CLCredentialManager
    ): TransactionService =
        TransactionServiceImpl(
            activity,
            TransactionRepository(CommonHeaders(), UpiCoreApiService()),
            credentialManager
        )

}