package com.payu.upiboltcore.constants

import com.payu.upiboltcore.InternalConfig

class URLConstants {

    companion object {

        const val PARAM_AUTHORIZATION = "Authorization"
        const val PARAM_USERNAME = "Username"
        const val PARAM_DEVICE_INFO = "DeviceInfo"
        const val PARAM_BANK_ID = "bankId"
        const val BANK_ID_VALUE = "hdfc"

        const val RES_PARAM_MESSAGE = "message"
        const val RES_PARAM_RESULT = "result"
        const val RES_PARAM_STATUS = "status"
        const val RES_PARAM_GUID = "guid"

        private val UPI_BASE_URL =
//            "http://192.168.1.107:8080/upi-plugin"
            if (InternalConfig.isProduction)
                "https://pp30api.payu.in/upi-plugin"
            else
                "https://pp30api.payu.in/upi-plugin"
        val CHECK_DEVICE_STATUS_URL = "$UPI_BASE_URL/v1/device"
        val GET_NPCI_TOKEN_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/token"
        val GET_LIST_KEYS_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/keys"
        val INITIATE_MPIN_SETUP_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/account/mpin"
        val CONFIRM_MPIN_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/account/mpin/setup"
        val ADD_ACCOUNT_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/account"
        val CHECK_VPA_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/vpa"
        val REGISTER_VPA_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/vpa/register"
        val CHANGE_MPIN_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/account/mpin"
        val MAKE_PAYMENT_URL = "$UPI_BASE_URL/v1/transaction"
        val BALANCE_ENQUIRY_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/account/balance"
        val BANKS_LIST_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/master-banks"
        val ACCOUNTS_LIST_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/accounts"
        val TRANSACTION_STATUS_URL = "$UPI_BASE_URL/v1/dispute-status"
        val RAISE_DISPUTE_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/dispute"
        val DISPUTE_LIST_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/disputeList"
        val DISPUTE_TYPE_LIST_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/disputes"
        val GET_PROFILE_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/profile"
        val REMOVE_ACCOUNT_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/removeAccount"
        val DEREGISTER_VPA_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/vpa"
        val VERIFY_SERVER_GEN_ID_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/verifyServerGenId"
        val TRANSACTION_HISTORY_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/txnhistory"
        val VALIDATE_OTP_URL = "$UPI_BASE_URL/v1/banks/${getBankId()}/validate-otp"

        private fun getBankId() = "bhim"

    }
}