package com.payu.upiboltcore.features.transaction

import com.payu.commonmodelssdk.constants.ApiConstant
import com.payu.commonmodelssdk.constants.PayUResponseCodes.PAYU_FAILED_STATUS
import com.payu.commonmodelssdk.listeners.ApiBaseCallback
import com.payu.commonmodelssdk.listeners.PayUAsyncTaskResponse
import com.payu.upiboltcore.models.CheckVPARequest
import com.payu.upiboltcore.models.CheckVPAResponse
import com.payu.upiboltcore.models.Credential
import com.payu.upiboltcore.models.GetProfileRequest
import com.payu.upiboltcore.models.GetProfileResponse
import com.payu.upiboltcore.models.MakePaymentRequest
import com.payu.upiboltcore.models.MakePaymentResponse
import com.payu.upiboltcore.models.MerchantDetails
import com.payu.upiboltcore.models.PayeeType
import com.payu.upiboltcore.models.PayerType
import com.payu.upiboltcore.network.BaseRepository
import com.payu.upiboltcore.network.CommonHeaders
import com.payu.upiboltcore.network.UpiCoreApiService
import com.payu.upiboltcore.npci.DeviceInfoManager

class TransactionRepository(
    private val commonHeaders: CommonHeaders,
    private val upiCoreApiService: UpiCoreApiService
) : BaseRepository() {

    fun checkVPA(vpa: String, requestType: String,referenceId:String?, apiCallback: ApiBaseCallback) {
        DeviceInfoManager.deviceInfo?.let { deviceInfo ->
            val headers = commonHeaders.getAuthTokenHeaders()
            val request = CheckVPARequest(
                PayeeType(virtualAddress = vpa),
                vpaRequestType = requestType,
                deviceInfo = deviceInfo,
                referenceId = referenceId).getJSONObject().toString()
            upiCoreApiService.checkVPA(headers, request, object:
                PayUAsyncTaskResponse {
                override fun onSuccess(response: Any) {
                    getResponse(response, apiCallback) {
                        try {
                            val checkVPAResponse = CheckVPAResponse.getCheckVPAResponseFromJSON(it)
                            sendSuccessCallback(apiCallback, checkVPAResponse)
                        }
                        catch (e: Exception){
                            sendFailureCallback(apiCallback, PAYU_FAILED_STATUS,
                                e.message.toString()
                            )
                        }

                    }
                }

                override fun onFailure(errorCode: Int, errorMessage: String) {
                    sendFailureCallback(apiCallback, errorCode, errorMessage)
                }

            })
        } ?: kotlin.run {
            sendFailureCallback(
                apiCallback, ApiConstant.SDK_RESPONSE_STATUS_CODE_1,
                ApiConstant.REQUEST_BODY_CANNOT_BE_NULL
            )
        }
    }

    fun getProfile(referenceId:String?,apiCallback: ApiBaseCallback) {
        DeviceInfoManager.deviceInfo?.let { deviceInfo ->
            val headers = commonHeaders.getAuthTokenHeaders()
            val request = GetProfileRequest(deviceInfo,referenceId = referenceId).getJSONObject().toString()
            upiCoreApiService.getProfile(headers, request, object: PayUAsyncTaskResponse {
                override fun onSuccess(response: Any) {
                    getResponse(response, apiCallback) {
                        try {
                            val getProfileResponse = GetProfileResponse.getProfileResponseFromJSON(it)
                            sendSuccessCallback(apiCallback, getProfileResponse)
                        }
                        catch (e: Exception){
                            sendFailureCallback(apiCallback,PAYU_FAILED_STATUS,
                                e.message.toString()
                            )
                        }

                    }
                }

                override fun onFailure(errorCode: Int, errorMessage: String) {
                    sendFailureCallback(apiCallback, errorCode, errorMessage)
                }
            })
        }
    }

    fun makePayment(
        amount: String,
        credential: Credential,
        merchantDetails: MerchantDetails? = null,
        payeeType: PayeeType,
        payerType: PayerType,
        note: String? = null,
        txnId:String,
        initMode: String,
        purpose: String,
        refId: String?,
        refUrl: String?,
        npciTxnId: String,
        referenceId:String?,
        apiCallback: ApiBaseCallback
    ) {
        DeviceInfoManager.deviceInfo?.let { deviceInfo ->
            val headers = commonHeaders.getAuthTokenHeaders()
            val request = MakePaymentRequest(
                amount = amount,
                credential = credential,
                deviceInfo = deviceInfo,
                initiationMode = initMode.ifEmpty { "10" },
                merchantDetails = merchantDetails,
                npciTranId = npciTxnId,
                payeeType = payeeType,
                payerType = payerType,
                refId = refId,
                refUrl = refUrl,
                transactionNote = note,
                txnId = txnId,
                purpose = purpose.ifEmpty { "00" },
                referenceId = referenceId
            ).getJSONObject().toString()
            upiCoreApiService.makePayment(headers, request, object:
                PayUAsyncTaskResponse {
                override fun onSuccess(response: Any) {
                    getResponse(response, apiCallback) {
                        try {
                            val makePaymentResponse = MakePaymentResponse.getInitMPinResponseFromJSON(it)
                            sendSuccessCallback(apiCallback, makePaymentResponse)
                        }
                        catch (e: Exception){
                            sendFailureCallback(apiCallback,PAYU_FAILED_STATUS,
                                e.message.toString()
                            )
                        }

                    }
                }

                override fun onFailure(errorCode: Int, errorMessage: String) {
                    sendFailureCallback(apiCallback, errorCode, errorMessage)
                }

            })
        } ?: kotlin.run {
            sendFailureCallback(
                apiCallback, ApiConstant.SDK_RESPONSE_STATUS_CODE_1,
                ApiConstant.REQUEST_BODY_CANNOT_BE_NULL
            )
        }
    }
}