package com.payu.upiboltcore.models

import com.payu.upiboltcore.utils.Utils
import org.json.JSONObject

data class AccountInfo(
    val accountId: String,
    val accountName: String,
    val accountNumber: String,
    val accountType: String,
    val aeba: String,
    val aepsFlag: String? = null,
    val atmPinLength: String? = null,
    val bankCode: String? = null,
    val bankId: String? = null,
    val bankName: String? = null,
    val credentialLength: String? = null,
    val credentialType: String? = null,
    val formatType: String,
    val ifscCode: String,
    val intlAccFlag: String? = null,
    val mbeba: String,
    val mpinFlag: String? = null,
    val otpDataType: String? = null,
    val otpLength: String? = null,
    val preferredFlag: String? = null,
    val refUrl: String? = null,
    val accountBalance: String? = null,
    val availableBal: String? = null,
    val uPinLength: String? = null,
    val unmaskAccountNo: String? = null,
    val otpCredentialType: String? = null,
    val iin: String,
    var vpa: String? = null,
    var atmDataType: String? = null
) {
    companion object {
        const val ACCOUNT_ID = "accountId"
        const val ACCOUNT_NAME = "accountName"
        const val ACCOUNT_NUMBER = "accountNo"
        const val ACCOUNT_TYPE = "accountType"
        const val AEBA = "aeba"
        const val AEPS_FLAG = "aepsFlag"
        const val ATM_PIN_LENGTH = "atmPinLength"
        const val BANK_CODE = "bankCode"
        const val BANK_ID = "bankId"
        const val BANK_NAME = "bankName"
        const val CREDENTIAL_LENGTH = "credentialLength"
        const val CREDENTIAL_TYPE = "credentialType"
        const val FORMAT_TYPE = "formatType"
        const val IFSC_CODE = "ifscCode"
        const val INTL_ACC_FLAG = "intlAccFlag"
        const val MBEBA = "mbeba"
        const val MPIN_FLAG = "mpinFlag"
        const val OTP_DATA_TYPE = "otpDataType"
        const val OTP_LENGTH = "otpLength"
        const val PREFERRED_FLAG = "preferredFlag"
        const val REF_URL = "refUrl"
        const val ACCOUNT_BALANCE = "accountBalance"
        const val AVAILABLE_BAL = "availableBal"
        const val U_PIN_LENGTH = "uPinLength"
        const val UNMASK_ACCOUNT_NO = "unmaskAccountNo"
        const val OTP_CREDENTIAL_TYPE = "otpCredentialType"
        const val IIN = "iin"
        const val VIRTUAL_ADDRESS = "virtualAddress"
        const val ATM_DATA_TYPE = "atmDataType"


        fun getAccountInfoFromJSON(jsonObject: JSONObject): AccountInfo {
            return AccountInfo(
                if (jsonObject.optString(ACCOUNT_ID).isNullOrEmpty()) {
                    jsonObject.optString("accId")
                } else {
                    jsonObject.optString(ACCOUNT_ID)
                },
                if (jsonObject.optString(ACCOUNT_NAME).isNullOrEmpty()) {
                    jsonObject.optString("accName")
                } else {
                    jsonObject.optString(ACCOUNT_NAME)
                },
                if (jsonObject.optString(ACCOUNT_NUMBER).isNullOrEmpty()) {
                    jsonObject.optString("accNo")
                } else {
                    jsonObject.optString(ACCOUNT_NUMBER)
                }
                ,jsonObject.optString(ACCOUNT_TYPE),
                if (jsonObject.optString(AEBA).isNullOrEmpty()) {
                    if (jsonObject.optString(AEPS_FLAG)?.toBoolean() == true) "Y" else "N"
                } else {
                    jsonObject.optString(AEBA)
                }, jsonObject.optString(AEPS_FLAG),
                if (jsonObject.optString(ATM_PIN_LENGTH).isNullOrEmpty()) {
                    jsonObject.optString("atmdLength")
                } else {
                    jsonObject.optString(ATM_PIN_LENGTH)
                }, jsonObject.optString(BANK_CODE),
                jsonObject.optString(BANK_ID), jsonObject.optString(BANK_NAME),
                if (jsonObject.optString(CREDENTIAL_LENGTH).isNullOrEmpty()) {
                    jsonObject.optString("crdLength")
                } else {
                    jsonObject.optString(CREDENTIAL_LENGTH)
                },
                if (jsonObject.optString(CREDENTIAL_TYPE).isNullOrEmpty()) {
                    jsonObject.optString("crdType")
                } else {
                    jsonObject.optString(CREDENTIAL_TYPE)
                },
                jsonObject.optString(FORMAT_TYPE), jsonObject.optString(IFSC_CODE),
                jsonObject.optString(INTL_ACC_FLAG),
                if (jsonObject.optString(MBEBA).isNullOrEmpty()) {
                    if (jsonObject.optString(MPIN_FLAG)?.toBoolean() == true) "Y" else "N"
                } else {
                    jsonObject.optString(MBEBA)
                },
                jsonObject.optString(MPIN_FLAG), jsonObject.optString(OTP_DATA_TYPE),
                if (jsonObject.optString(OTP_LENGTH).isNullOrEmpty()) {
                    jsonObject.optString("otpdLength")
                } else {
                    jsonObject.optString(OTP_LENGTH)
                }, jsonObject.optString(PREFERRED_FLAG),
                jsonObject.optString(REF_URL), jsonObject.optString(ACCOUNT_BALANCE),
                jsonObject.optString(AVAILABLE_BAL), jsonObject.optString(U_PIN_LENGTH),
                jsonObject.optString(UNMASK_ACCOUNT_NO), jsonObject.optString(OTP_CREDENTIAL_TYPE),
                jsonObject.optString(IIN), jsonObject.optString(VIRTUAL_ADDRESS),
                jsonObject.optString(ATM_DATA_TYPE)
            )
        }
    }

    fun getJSONObject(maskPi: Boolean = false, logInfo: Boolean = false): JSONObject {
        return JSONObject().apply {
            put(
                ACCOUNT_ID,
                if (maskPi)
                    Utils.getMaskedString(accountId)
                else
                    accountId
            )
            put(ACCOUNT_NAME, accountName)
            put(ACCOUNT_NUMBER, accountNumber)
            put(ACCOUNT_TYPE, accountType)
            put(AEBA, aeba)
            put(AEPS_FLAG, aepsFlag)
            put(ATM_PIN_LENGTH, atmPinLength)
            put(BANK_CODE, bankCode)
            put(BANK_ID, bankId)
            put(BANK_NAME, bankName)
            put(CREDENTIAL_LENGTH, credentialLength)
            put(CREDENTIAL_TYPE, credentialType)
            put(FORMAT_TYPE, formatType)
            put(IFSC_CODE, ifscCode)
            put(INTL_ACC_FLAG, intlAccFlag)
            put(MBEBA, mbeba)
            put(MPIN_FLAG, mpinFlag)
            put(OTP_DATA_TYPE, otpDataType)
            put(OTP_LENGTH, otpLength)
            put(PREFERRED_FLAG, preferredFlag)
            put(REF_URL, refUrl)
            if (logInfo.not()) {
                put(ACCOUNT_BALANCE, accountBalance)
                put(AVAILABLE_BAL, availableBal)
            }
            put(U_PIN_LENGTH, uPinLength)
            put(
                UNMASK_ACCOUNT_NO,
                if (maskPi)
                    Utils.getMaskedString(unmaskAccountNo)
                else
                    unmaskAccountNo
            )
            put(OTP_CREDENTIAL_TYPE, otpCredentialType)
            put(IIN, iin)
            put(
                VIRTUAL_ADDRESS,
                if (maskPi)
                    Utils.getMaskedString(vpa)
                else
                    vpa
            )
            put(ATM_DATA_TYPE, atmDataType)
        }
    }
}