package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class AccountListResponse(
    val guid: String,
    val message: String,
    val result: AccountListResponseResult,
    val status: Int
) {
    companion object {
        fun getAccountListResponseFromJSON(string: String): AccountListResponse {
            val json = JSONObject(string)
            val result = AccountListResponseResult.getAccountListResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return AccountListResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class AccountListResponseResult(
    val status: String,
    val statusDesc: String,
    val accountList: List<AccountInfo>,
    val pspRespRefNo: String?=null,
    val virtualAddress: String?=null
) {
    companion object {
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val ACCOUNT_LIST = "accountList"
        const val PSP_RESP_REF_NUM = "pspRespRefNo"
        const val VIRTUAL_ADDRESS = "virtualAddress"

        fun getAccountListResponseResultFromJSON(jsonObject: JSONObject): AccountListResponseResult {
            var accountList = emptyList<AccountInfo>()
            var vpa : String? =null

            if(jsonObject.has(VIRTUAL_ADDRESS)){
              vpa = jsonObject.optString(VIRTUAL_ADDRESS)
            }

            if(jsonObject.has(ACCOUNT_LIST)) {
                val accountListArray = jsonObject.getJSONArray(ACCOUNT_LIST)
                    accountList = List(accountListArray.length()) {
                    AccountInfo.getAccountInfoFromJSON(accountListArray.getJSONObject(it))
                } }
            return AccountListResponseResult(
                jsonObject.optString(STATUS),
                jsonObject.optString(STATUS_DESC), accountList,jsonObject.optString(PSP_RESP_REF_NUM),vpa
            )
        }
    }
}