package com.payu.upiboltcore.models

import org.json.JSONObject

data class AccountsListRequest(
    val bankCode: String?=null,
    val deviceInfo: DeviceInfo,
    val requestType: String?,
    val userInfo: UserInfo? = null,
    val referenceId: String?=null
) {
    companion object {
        const val BANK_CODE = "bankCode"
        const val DEVICE_INFO = "deviceInfo"
        const val REQUEST_TYPE = "requestType"
        const val USER_INFO = "userInfo"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(BANK_CODE, bankCode)
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(REQUEST_TYPE, requestType)
            userInfo?.let {
                put(USER_INFO, it.getJSONObject())
            }
            put(REFERENCE_ID, referenceId)
        }
    }
}