package com.payu.upiboltcore.models

import org.json.JSONObject

data class BalanceEnquiryRequest(
    val accountId: String?=null,
    val deviceInfo: DeviceInfo,
    val mpinCredential: Credential,
    val npciTxnId: String?=null,
    val virtualAddress: String?=null,
    val referenceId: String?=null
) {
    companion object {
        const val ACCOUNT_ID = "accountId"
        const val DEVICE_INFO = "deviceInfo"
        const val MPIN_CREDENTIAL = "mpinCredential"
        const val NPCI_TXN_ID = "npciTxnId"
        const val VIRTUAL_ADDRESS = "virtualAddress"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(ACCOUNT_ID, accountId)
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(MPIN_CREDENTIAL, mpinCredential.getJSONObject())
            put(NPCI_TXN_ID, npciTxnId)
            put(VIRTUAL_ADDRESS, virtualAddress)
            put(REFERENCE_ID, referenceId)
        }
    }
}