package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class BalanceEnquiryResponse(
    val guid: String,
    val message: String,
    val result: BalanceEnquiryResponseResult,
    val status: Int
) {
    companion object {
        fun getBalanceEnquiryResponseFromJSON(string: String): BalanceEnquiryResponse {
            val json = JSONObject(string)
            val result = BalanceEnquiryResponseResult.getBalanceEnquiryResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return BalanceEnquiryResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class BalanceEnquiryResponseResult(
    val accountInfo: AccountInfo,
    val npciTranId: String,
    val statusDescrption: String
) {
    companion object {
        const val ACCOUNT_INFO = "accountInfo"
        const val NPCI_TRAN_ID = "npciTranId"
        const val STATUS_DESCRIPTION = "statusDescrption"

        fun getBalanceEnquiryResponseResultFromJSON(jsonObject: JSONObject): BalanceEnquiryResponseResult {
            val accountInfo = AccountInfo.getAccountInfoFromJSON(jsonObject.getJSONObject(ACCOUNT_INFO))
            return BalanceEnquiryResponseResult(accountInfo, jsonObject.optString(NPCI_TRAN_ID),
                jsonObject.optString(STATUS_DESCRIPTION))
        }
    }

    fun getJSONObject(maskPi: Boolean = false, logInfo: Boolean = false): JSONObject {
        return JSONObject().apply {
            put(ACCOUNT_INFO, accountInfo.getJSONObject(maskPi, logInfo))
            put(NPCI_TRAN_ID, npciTranId)
            put(STATUS_DESCRIPTION, statusDescrption)
        }
    }
}