package com.payu.upiboltcore.models

import com.payu.commonmodelssdk.model.response.PayUBankData
import org.json.JSONObject

data class Bank(
    val bankCode: String,
    val bankId: String,
    val bankName: String,
    val formatType: String,
    val ifsc: String,
    val iin: String,
    val statusCode: String,
) {
    companion object {
        const val BANK_CODE = "bankCode"
        const val BANK_ID = "bankId"
        const val BANK_NAME = "bankName"
        const val FORMAT_TYPE = "formatType"
        const val IFSC = "ifsc"
        const val IIN = "iin"
        const val STATUS_CODE = "statusCode"

        fun getBankFromJSON(jsonObject: JSONObject): Bank {
            return Bank(
                jsonObject.optString(BANK_CODE), jsonObject.opt(BANK_ID)?.toString() ?: "",
                jsonObject.optString(BANK_NAME), jsonObject.optString(FORMAT_TYPE),
                jsonObject.optString(IFSC), jsonObject.optString(IIN),
                jsonObject.optString(STATUS_CODE)
            )
        }

        fun getBankData(bank: Bank): PayUBankData {
            return PayUBankData(bank.bankName, bank.iin, bank.ifsc, null, bank.bankCode, bank.bankId)
        }
    }
}