package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject


data class BanksListResponse(
    val guid: String,
    val message: String,
    val result: BanksListResponseResult,
    val status: Int
) {
    companion object {
        fun getBanksListResponseFromJSON(string: String): BanksListResponse {
            val json = JSONObject(string)
            val result = BanksListResponseResult.getBanksListResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return BanksListResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class BanksListResponseResult(
    val status: String,
    val statusDesc: String,
    val bankMasterList: List<Bank>
) {
    companion object {
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val BANKS_MASTER_LIST = "bankMasterList"

        fun getBanksListResponseResultFromJSON(jsonObject: JSONObject): BanksListResponseResult {
            val banksListArray = jsonObject.getJSONArray(BANKS_MASTER_LIST)
            val banksList = List(banksListArray.length()) {
                Bank.getBankFromJSON(banksListArray.getJSONObject(it))
            }
            return BanksListResponseResult(jsonObject.optString(STATUS), jsonObject.optString(
                STATUS_DESC), banksList)
        }
    }
}
