package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

open class BaseResponse(
    open val guid: String,
    open val message: String,
    open val result: BaseResponseResult?,
    open val status: Int
) {
    companion object {

        fun getBaseResponseFromJSON(string: String): BaseResponse {
            val json = JSONObject(string)
            val resultJson = json.optJSONObject(URLConstants.RES_PARAM_RESULT)
            val result = resultJson?.let {
                BaseResponseResult.getBaseResponseFromJSON(it)
            }

            return BaseResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

open class BaseResponseResult(
    open val status: String?,
    open val statusDesc: String?,
    open val errorCode: String?
) {
    companion object {

        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val ERROR_CODE = "errorCode"

        fun getBaseResponseFromJSON(jsonObject: JSONObject?): BaseResponseResult? {
            return jsonObject?.let {
                BaseResponseResult(
                    jsonObject.optString(STATUS),
                    jsonObject.optString(STATUS_DESC),
                    jsonObject.optString(ERROR_CODE)
                )
            }
        }
    }
}
