package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class ChangeMPinResponse(
    val guid: String,
    val message: String,
    val result: ChangeMPinResponseResult,
    val status: Int
) {
    companion object {
        fun getChangeMPinResponseFromJSON(string: String): ChangeMPinResponse {
            val json = JSONObject(string)
            val result = ChangeMPinResponseResult.getChangeMPinResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return ChangeMPinResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class ChangeMPinResponseResult(
    val npciTransId: String,
    val status: String,
    val statusDesc: String
) {
    companion object {
        const val NPCI_TRANS_ID = "npciTransId"
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"

        fun getChangeMPinResponseResultFromJSON(jsonObject: JSONObject): ChangeMPinResponseResult {
            return ChangeMPinResponseResult(jsonObject.optString(NPCI_TRANS_ID),
                jsonObject.optString(STATUS), jsonObject.optString(STATUS_DESC))
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(NPCI_TRANS_ID ,npciTransId)
            put(STATUS, status)
            put(STATUS_DESC, statusDesc)
        }
    }
}