package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class CheckDeviceStatusResponse(
    val guid: String,
    val message: String,
    val result: CheckDeviceStatusResult,
    val status: Int
) {

    companion object {
        fun getCheckDeviceStatusResponseFromJSON(string: String): CheckDeviceStatusResponse {
            val json = JSONObject(string)
            val result = CheckDeviceStatusResult.getCheckDeviceStatusResponseFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return CheckDeviceStatusResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class CheckDeviceStatusResult(
    val deviceBindTimeSec: Int? = null,
    val deviceInfo: DeviceInfo? = null,
    val deviceStatus: String,
    val flowSimId: String? = null,
    val isPreRegUser: Boolean? = null,
    val isUserReg: Boolean? = null,
    val npciTokenRefreshFlag: String? = null,
    val preRegId: Int? = null,
    val sessionFlag: Int? = null,
    val simStatus: String,
    val smsGateWayContent: String,
    val smsGateWayKey: String,
    val smsGateWayNo: String,
    val smsStatus: String,
    val status: String,
    val statusDesc: String,
    val userInfo: UserInfo? = null
) {

    companion object {
        const val DEVICE_BINDING_TIME_SEC = "deviceBindTimeSec"
        const val DEVICE_INFO = "deviceInfo"
        const val DEVICE_STATUS = "deviceStatus"
        const val FLOW_SIM_ID = "flowSimId"
        const val IS_PRE_REG_USER = "isPreRegUser"
        const val IS_USER_REG = "isUserReg"
        const val NPCI_TOKEN_REFRESH_FLAG = "npciTokenRefreshFlag"
        const val PRE_REG_ID = "preRegId"
        const val SESSION_FLAG = "sessionFlag"
        const val SIM_STATUS = "simStatus"
        const val SMS_GATEWAY_CONTENT = "smsGateWayContent"
        const val SMS_GATEWAY_KEY = "smsGateWayKey"
        const val SMS_GATEWAY_NO = "smsGateWayNo"
        const val SMS_STATUS = "smsStatus"
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val USER_INFO = "userInfo"

        fun getCheckDeviceStatusResponseFromJSON(json: JSONObject): CheckDeviceStatusResult {
            val deviceInfo = json.optJSONObject(DEVICE_INFO)?.let { DeviceInfo.getDeviceInfoFromJSON(it) }
            val userInfo = json.optJSONObject(USER_INFO)?.let { UserInfo.getUserInfoFromJSON(it) }
            return CheckDeviceStatusResult(
                json.optInt(DEVICE_BINDING_TIME_SEC),
                deviceInfo,
                json.optString(DEVICE_STATUS),
                json.optString(FLOW_SIM_ID),
                json.optBoolean(IS_PRE_REG_USER),
                json.optBoolean(IS_USER_REG),
                json.optString(NPCI_TOKEN_REFRESH_FLAG),
                json.optInt(PRE_REG_ID),
                json.optInt(SESSION_FLAG),
                json.optString(SIM_STATUS),
                json.optString(SMS_GATEWAY_CONTENT),
                json.optString(SMS_GATEWAY_KEY),
                json.optString(SMS_GATEWAY_NO),
                json.optString(SMS_STATUS),
                json.optString(STATUS),
                json.optString(STATUS_DESC),
                userInfo
            )
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            deviceBindTimeSec?.let { put(DEVICE_BINDING_TIME_SEC, it) }
            deviceInfo?.let { put(DEVICE_INFO, it) }
            put(DEVICE_STATUS, deviceStatus)
            flowSimId?.let { put(FLOW_SIM_ID, it) }
            isPreRegUser?.let { put(IS_PRE_REG_USER, it) }
            isUserReg?.let { put(IS_USER_REG, it) }
            npciTokenRefreshFlag?.let { put(NPCI_TOKEN_REFRESH_FLAG, it) }
            preRegId?.let { put(PRE_REG_ID, it) }
            sessionFlag?.let { put(SESSION_FLAG, it) }
            put(SIM_STATUS, simStatus)
            put(SMS_GATEWAY_CONTENT, smsGateWayContent)
            put(SMS_GATEWAY_KEY, smsGateWayKey)
            put(SMS_GATEWAY_NO, smsGateWayNo)
            put(SMS_STATUS, smsStatus)
            put(STATUS, status)
            put(STATUS_DESC, statusDesc)
            userInfo?.let { put(USER_INFO, it) }
        }
    }
}