package com.payu.upiboltcore.models

import org.json.JSONObject

data class CheckVPARequest(
    val payeeType: PayeeType,
    val vpaRequestType: String,
    val deviceInfo: DeviceInfo,
    val referenceId: String?=null
) {
    companion object {
        const val PAYEE_TYPE = "payeeType"
        const val VPA_REQUEST_TYPE = "vpaRequestType"
        const val DEVICE_INFO = "deviceInfo"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(PAYEE_TYPE, payeeType.getJSONObject())
            put(VPA_REQUEST_TYPE, vpaRequestType)
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(REFERENCE_ID, referenceId)
        }
    }
}