package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONArray
import org.json.JSONObject

data class CheckVPAResponse(
    val guid: String,
    val message: String,
    val result: CheckVPAResponseResult,
    val status: Int
) {

    companion object {
        fun getCheckVPAResponseFromJSON(string: String): CheckVPAResponse {
            val json = JSONObject(string)
            val result = CheckVPAResponseResult.getCheckVPAResponseFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return CheckVPAResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class CheckVPAResponseResult(
    val merchantDetails: MerchantDetails?,
    val payeeList: List<PayeeList>,
    val paymentType: String?,
    val status: String,
    val statusDesc: String,
    val verificationFlag: Boolean
) {

    companion object {
        const val MERCHANT_DETAILS = "merchantDetails"
        const val PAYEE_LIST = "payeeList"
        const val PAYMENT_TYPE = "paymentType"
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val VERIFICATION_FLAG = "verificationFlag"

        fun getCheckVPAResponseFromJSON(jsonObject: JSONObject): CheckVPAResponseResult {
            var merchantDetails : MerchantDetails? = null
            var payeeList : List<PayeeList> = emptyList()
            var paymentType : String? = null

            if(jsonObject.has(MERCHANT_DETAILS)) {
                 merchantDetails = MerchantDetails.getMerchantDetailsFromJSON(
                    jsonObject.getJSONObject(MERCHANT_DETAILS)
                )
            }

            if(jsonObject.has(PAYEE_LIST)) {
                 payeeList = PayeeList.getPayeeListFromJSON(jsonObject.getJSONArray(PAYEE_LIST))
            }
            if(jsonObject.has(PAYMENT_TYPE)) {
                paymentType = jsonObject.optString(PAYMENT_TYPE)
            }
            return CheckVPAResponseResult(merchantDetails, payeeList,paymentType ,
                jsonObject.optString(STATUS), jsonObject.optString(STATUS_DESC),
                jsonObject.optBoolean(VERIFICATION_FLAG))
        }
    }
}

data class PayeeList(
    val name: String,
    val status: String,
    val statusDesc: String,
    val virtualAddress: String
) {
    companion object {
        const val NAME = "name"
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val VIRTUAL_ADDRESS = "virtualAddress"

        fun getPayeeListFromJSON(jsonArray: JSONArray): List<PayeeList> {
            val payeeList = List(jsonArray.length()) {
                PayeeList(jsonArray.getJSONObject(it).optString(NAME),
                    jsonArray.getJSONObject(it).optString(STATUS),
                    jsonArray.getJSONObject(it).optString(STATUS_DESC),
                    jsonArray.getJSONObject(it).optString(VIRTUAL_ADDRESS))
            }
            return payeeList
        }
    }
}