package com.payu.upiboltcore.models

import org.json.JSONObject

data class Credential(
    val credentialDataType: String? = null,
    val credentialDataLength: String? = null,
    var atmCredentialLength: String? = null,
    var atmCredentialType: String? = null,
    val atmFormatType: String? = null,
    var otpCredentialLength: String? = null,
    var otpCredentialType: String? = null,
    var credentialDataCode: String? = null,
    var credentialDataKi: String? = null,
    var credentialDataValue: String? = null,
    var credentialSubType: String? = null,
    val credentialType: String? = null,
    val aadharCrdLength: String? = null
) {

    companion object {
        const val CREDENTIAL_DATA_TYPE = "credentialDataType"
        const val CREDENTIAL_DATA_LENGTH = "credentialDataLength"
        const val ATM_CREDENTIAL_LENGTH = "atmCredentialLength"
        const val ATM_CREDENTIAL_TYPE = "atmCredentialType"
        const val ATM_FORMAT_TYPE = "atmFormatType"
        const val OTP_CREDENTIAL_LENGTH = "otpCredentialLength"
        const val OTP_CREDENTIAL_TYPE = "otpCredentialType"
        const val CREDENTIAL_DATA_CODE = "credentialDataCode"
        const val CREDENTIAL_DATA_KI = "credentialDataKi"
        const val CREDENTIAL_DATA_VALUE = "credentialDataValue"
        const val CREDENTIAL_SUB_TYPE = "credentialSubType"
        const val CREDENTIAL_TYPE = "credentialType"
        const val AADHAR_CRD_LENGTH = "aadharCrdLength"

        fun getCredentialFromJSON(jsonObject: JSONObject): Credential {
            return Credential(
                jsonObject.optString(CREDENTIAL_DATA_TYPE),
                jsonObject.optString(CREDENTIAL_DATA_LENGTH),
                jsonObject.optString(ATM_CREDENTIAL_LENGTH),
                jsonObject.optString(ATM_CREDENTIAL_TYPE),
                jsonObject.optString(ATM_FORMAT_TYPE),
                jsonObject.optString(OTP_CREDENTIAL_LENGTH),
                jsonObject.optString(OTP_CREDENTIAL_TYPE),
                jsonObject.optString(CREDENTIAL_DATA_CODE),
                jsonObject.optString(CREDENTIAL_DATA_KI),
                jsonObject.optString(CREDENTIAL_DATA_VALUE),
                jsonObject.optString(CREDENTIAL_SUB_TYPE),
                jsonObject.optString(CREDENTIAL_TYPE),
                jsonObject.optString(AADHAR_CRD_LENGTH)
            )
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(CREDENTIAL_DATA_TYPE, credentialDataType)
            put(CREDENTIAL_DATA_LENGTH, credentialDataLength)
            put(ATM_CREDENTIAL_LENGTH, atmCredentialLength)
            put(ATM_CREDENTIAL_TYPE, atmCredentialType)
            put(ATM_FORMAT_TYPE, atmFormatType)
            put(OTP_CREDENTIAL_LENGTH, otpCredentialLength)
            put(OTP_CREDENTIAL_TYPE, otpCredentialType)
            put(CREDENTIAL_DATA_CODE, credentialDataCode)
            put(CREDENTIAL_DATA_KI, credentialDataKi)
            put(CREDENTIAL_DATA_VALUE, credentialDataValue)
            put(CREDENTIAL_SUB_TYPE, credentialSubType)
            put(CREDENTIAL_TYPE, credentialType)
            put(AADHAR_CRD_LENGTH, aadharCrdLength)
        }
    }
}
