package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class DisputeListResponse(
    val guid: String,
    val message: String,
    val result: DisputeListResponseResult,
    val status: Int
) {
    companion object {
        fun getDisputeListResponseFromJSON(string: String): DisputeListResponse {
            val json = JSONObject(string)
            val result = DisputeListResponseResult.getDisputeListResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return DisputeListResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class DisputeListResponseResult(
    val status: String,
    val statusDesc: String,
    val errCode: String,
    val listofCustDispute: List<CustDisputeList>

) {
    companion object {
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val ERR_CODE = "errCode"
        const val LIST_OF_CUST_DISPUTE = "listofCustDispute"
        fun getDisputeListResponseResultFromJSON(jsonObject: JSONObject): DisputeListResponseResult {
            val complaintInfoListArray = jsonObject.getJSONArray(LIST_OF_CUST_DISPUTE)
            val complaintInfoList = List(complaintInfoListArray.length()) {
                CustDisputeList.getComplaintInfoListFromJSON(complaintInfoListArray.getJSONObject(it))
            }
            return DisputeListResponseResult(jsonObject.optString(STATUS)
            ,jsonObject.optString(STATUS_DESC)
                ,jsonObject.optString(ERR_CODE)
            ,complaintInfoList)
        }
    }
}
data class CustDisputeList(
    val pgMeTrnRefNo: String? = null,
    val status: String? = null,
    val storeId: String? = null,
    val fvaddr: String? = null,
    val custid: String? = null,
    val targetDate: String? = null,
    val custRefNo: String? = null,
    val reqReasnDesc: String? = null,
    val txnRemark: String? = null,
    val amount: String? = null,
    val crtDate: String? = null,
    val ticketNo: String? = null,
    val txnid: String? = null
    ) {
    companion object {
        const val PG_ME_TRN_REF_NO = "pgMeTrnRefNo"
        const val STATUS = "status"
        const val STORE_ID = "storeId"
        const val FV_ADD_R = "fvaddr"
        const val CUST_ID = "custid"
        const val TARGET_DATE = "targetDate"
        const val CUST_REF_NO = "custRefNo"
        const val REQ_REASON_DESC = "reqReasnDesc"
        const val TXN_REMARK = "txnRemark"
        const val AMOUNT = "amount"
        const val CRT_DATE = "crtDate"
        const val TICKET_NUM = "ticketNo"
        const val TXN_ID = "txnid"
        fun getComplaintInfoListFromJSON(jsonObject: JSONObject): CustDisputeList {
            return CustDisputeList(
                jsonObject.optString(PG_ME_TRN_REF_NO)
                        ,jsonObject.optString(STATUS)
                        ,jsonObject.optString(STORE_ID)
                        ,jsonObject.optString(FV_ADD_R)
                        ,jsonObject.optString(CUST_ID)
                        ,jsonObject.optString(TARGET_DATE)
                        ,jsonObject.optString(CUST_REF_NO)
                        ,jsonObject.optString(REQ_REASON_DESC)
                        ,jsonObject.optString(TXN_REMARK)
                        ,jsonObject.optString(AMOUNT)
                        ,jsonObject.optString(CRT_DATE)
                ,jsonObject.optString(TICKET_NUM)
                ,jsonObject.optString(TXN_ID))
        }
    }
}