package com.payu.upiboltcore.models

import org.json.JSONObject

data class DisputeTypeListRequest(
    val deviceInfo: DeviceInfo,
    val upiTransactionRefNo: String,
    val referenceId: String?
) {

    companion object {
        const val DEVICE_INFO = "deviceInfo"
        const val UPI_TRANSACTION_REF_NUM = "upiTransactionRefNo"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(UPI_TRANSACTION_REF_NUM, upiTransactionRefNo)
            put(REFERENCE_ID, referenceId)
        }
    }
}
